% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie-search.R
\name{cie_lookup}
\alias{cie_lookup}
\title{Busqueda exacta por codigo CIE-10}
\usage{
cie_lookup(
  codigo,
  expandir = FALSE,
  normalizar = TRUE,
  descripcion_completa = FALSE,
  extract = FALSE,
  check_siglas = FALSE
)
}
\arguments{
\item{codigo}{Character vector de codigos (ej. "E11", "E11.0", c("E11.0", "Z00"))
o rango (ej. "E10-E14"). Acepta vectores de multiples codigos.
Soporta formatos: con punto (E11.0), sin punto (E110), o solo categoria (E11).}

\item{expandir}{Logical, expandir jerarquia completa (default FALSE)}

\item{normalizar}{Logical, normalizar formato de codigos automaticamente (default TRUE)}

\item{descripcion_completa}{Logical, agregar columna descripcion_completa con formato "CODIGO - DESCRIPCION" (default FALSE)}

\item{extract}{Logical, extraer codigo CIE-10 de texto con prefijos/sufijos (default FALSE).
IMPORTANTE: Solo usar con codigo ESCALAR (longitud 1). Ejemplo: "CIE:E11.0" -> "E11.0", "E11.0-confirmado" -> "E11.0".
Para vectores multiples usar extract=FALSE (default).}

\item{check_siglas}{Logical, buscar siglas medicas comunes (default FALSE).
Ejemplo: "IAM" -> I21.0 (Infarto agudo miocardio)}
}
\value{
tibble con codigo(s) matcheado(s)
}
\description{
Busqueda exacta por codigo CIE-10
}
\examples{
cie_lookup("E11.0")       # Con punto
cie_lookup("E110")        # Sin punto
cie_lookup("E11")         # Solo categoria
cie_lookup("E11", expandir = TRUE)  # Todos E11.x
# Vectorizado - multiples codigos y formatos
cie_lookup(c("E11.0", "Z00", "I10"))
# Con descripcion completa
cie_lookup("E110", descripcion_completa = TRUE)
# Extraer codigo de texto con ruido (solo codigo escalar)
cie_lookup("CIE:E11.0", extract = TRUE)
cie_lookup("E11.0-confirmado", extract = TRUE)
# Nota: Para vectores multiples usar extract=FALSE (default)
# Buscar por siglas medicas
cie_lookup("IAM", check_siglas = TRUE)
cie_lookup("DM2", check_siglas = TRUE)
cie_lookup("EPOC", check_siglas = TRUE)
}
