% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridding.R
\name{par_make_grid}
\alias{par_make_grid}
\title{Generate grid polygons}
\usage{
par_make_grid(points_in = NULL, ncutsx = NULL, ncutsy = NULL)
}
\arguments{
\item{points_in}{\code{sf} or \code{SpatVector} object. Target points of computation.
character(1) of file path is also acceptable.}

\item{ncutsx}{integer(1). The number of splits along x-axis.}

\item{ncutsy}{integer(1). The number of splits along y-axis.}
}
\value{
A \code{sf} or \code{SpatVector} object of computation grids with
unique grid id (CGRIDID).
}
\description{
Returns a sf object that includes x- and y- index
by using two inputs ncutsx and ncutsy, which are x- and
y-directional splits, respectively.
}
\note{
Grids are generated based on the extent of \code{points_in} first,
then exhaustive grids will be filtered by the intersection between
these and \code{points_in}. Thus, the number of generated grids may be
smaller than \code{ncutsx * ncutsy}.
}
\seealso{
Other Parallelization: 
\code{\link{par_cut_coords}()},
\code{\link{par_grid}()},
\code{\link{par_grid_mirai}()},
\code{\link{par_hierarchy}()},
\code{\link{par_hierarchy_mirai}()},
\code{\link{par_make_dggrid}()},
\code{\link{par_make_h3}()},
\code{\link{par_merge_grid}()},
\code{\link{par_multirasters}()},
\code{\link{par_multirasters_mirai}()},
\code{\link{par_pad_balanced}()},
\code{\link{par_pad_grid}()},
\code{\link{par_split_list}()}
}
\author{
Insang Song
}
\concept{Parallelization}
\keyword{internal}
