% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_likelihood.R
\name{choice_likelihood}
\alias{choice_likelihood}
\alias{compute_choice_likelihood}
\title{Define and compute choice likelihood}
\usage{
choice_likelihood(
  choice_data,
  choice_effects,
  choice_identifiers = extract_choice_identifiers(choice_data),
  input_checks = TRUE,
  lower_bound = 1e-10,
  ...
)

compute_choice_likelihood(
  choice_parameters,
  choice_data,
  choice_effects,
  logarithm = TRUE,
  negative = FALSE,
  lower_bound = 1e-10,
  input_checks = TRUE,
  ...
)
}
\arguments{
\item{choice_data}{[\code{choice_data}]\cr
A \code{\link{choice_data}} object with the observed choices.}

\item{choice_effects}{[\code{choice_effects}]\cr
A \code{\link{choice_effects}} object that determines the model effects.}

\item{choice_identifiers}{[\code{choice_identifiers}]\cr
A \code{\link{choice_identifiers}} object. The default extracts identifiers
from \code{choice_data}.}

\item{input_checks}{[\code{logical(1)}]\cr
Forwarded to \code{\link{choiceprob_probit}} or
\code{\link{choiceprob_logit}} to control additional input validation.}

\item{lower_bound}{[\code{numeric(1)}]\cr
The minimum probability used when computing the log-likelihood. Values below
this bound are truncated to avoid taking the logarithm of zero.}

\item{...}{Additional arguments passed to \code{\link{choiceprob_probit}} or
\code{\link{choiceprob_logit}}.}

\item{choice_parameters}{[\code{choice_parameters} | \code{list}]\cr
A \code{\link{choice_parameters}} object or a list as returned by
\code{\link{switch_parameter_space}}. When a numeric vector in optimization
space is supplied, it is converted via \code{switch_parameter_space()}.}

\item{logarithm}{[\code{logical(1)}]\cr
Return the log-likelihood? If \code{FALSE}, the likelihood is returned.}

\item{negative}{[\code{logical(1)}]\cr
Return the negative (log-)likelihood? Useful for minimization routines.}
}
\value{
\code{choice_likelihood()} returns an object of class \code{choice_likelihood}, which
is a \code{list} containing the design matrices, the choice indices, and the
identifiers. \code{compute_choice_likelihood()} returns a single numeric value
with the (negative) log-likelihood or likelihood, depending on \code{logarithm}
and \code{negative}.
}
\description{
These functions prepare and evaluate the likelihood contribution of observed
choices for a given choice model.
\itemize{
\item \code{choice_likelihood()} pre-computes the design matrices and choice indices
implied by \code{choice_data} and \code{choice_effects}. The returned object stores
these quantities so that repeated likelihood evaluations during maximum
likelihood estimation avoid redundant work.
\item \code{compute_choice_likelihood()} evaluates the (log-)likelihood for given
\code{choice_parameters}. It can either take the original choice objects or a
pre-computed \code{choice_likelihood} object.
}
}
\examples{
data(train_choice)

choice_effects <- choice_effects(
  choice_formula = choice_formula(
    formula = choice ~ price | time,
    error_term = "probit"
  ),
  choice_alternatives = choice_alternatives(
    J = 2, alternatives = c("A", "B")
  )
)

choice_data <- choice_data(
  data_frame = train_choice,
  format = "wide",
  column_choice = "choice",
  column_decider = "deciderID",
  column_occasion = "occasionID"
)

likelihood <- choice_likelihood(
  choice_data = choice_data,
  choice_effects = choice_effects
)

choice_parameters <- generate_choice_parameters(choice_effects)

compute_choice_likelihood(
  choice_parameters = choice_parameters,
  choice_data = likelihood,
  choice_effects = choice_effects,
  logarithm = TRUE
)
}
\keyword{probability}
