% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_covariates.R
\name{choice_covariates}
\alias{choice_covariates}
\alias{generate_choice_covariates}
\alias{covariate_names}
\alias{design_matrices}
\title{Define choice covariates}
\usage{
choice_covariates(
  data_frame,
  format = "wide",
  column_decider = "deciderID",
  column_occasion = NULL,
  column_alternative = NULL,
  column_ac_covariates = NULL,
  column_as_covariates = NULL,
  delimiter = "_",
  cross_section = is.null(column_occasion)
)

generate_choice_covariates(
  choice_effects = NULL,
  choice_identifiers = generate_choice_identifiers(N = 100),
  labels = covariate_names(choice_effects),
  n = nrow(choice_identifiers),
  marginals = list(),
  correlation = diag(length(labels)),
  verbose = FALSE,
  delimiter = "_"
)

covariate_names(choice_effects)

design_matrices(
  x,
  choice_effects,
  choice_identifiers = extract_choice_identifiers(x)
)
}
\arguments{
\item{data_frame}{[\code{data.frame}]\cr
Contains the choice covariates.}

\item{format}{[\code{character(1)}]\cr
Format of \code{data_frame}. Use \code{"wide"} when covariates for all alternatives are
stored in a single row per occasion and \code{"long"} when each alternative forms
a separate row.}

\item{column_decider}{[\code{character(1)}]\cr
Column name with decider identifiers.}

\item{column_occasion}{[\code{character(1)} | \code{NULL}]\cr
Column name with occasion identifiers. Set to \code{NULL} for cross-sectional
data.}

\item{column_alternative}{[\code{character(1)} | \code{NULL}]\cr
Column name with alternative identifiers when \code{format = "long"}.}

\item{column_ac_covariates}{[\code{character()} | \code{NULL}]\cr
Column names with alternative-constant covariates.}

\item{column_as_covariates}{[\code{character()} | \code{NULL}]\cr
Column names with alternative-specific covariates in \code{data_frame}.}

\item{delimiter}{[\code{character(1)}]\cr
Delimiter separating alternative identifiers from covariate names in wide
format. May consist of one or more characters.}

\item{cross_section}{[\code{logical(1)}]\cr
Treat choice data as cross-sectional?}

\item{choice_effects}{[\code{choice_effects} | \code{NULL}]\cr
Optional \code{\link{choice_effects}} object used to align covariate labels.}

\item{choice_identifiers}{[\code{choice_identifiers}]\cr
A \code{\link{choice_identifiers}} object describing the simulated panel.}

\item{labels}{[\code{character()}]\cr
Unique labels for the regressors.}

\item{n}{[\code{integer(1)}]\cr
The number of values per regressor.}

\item{marginals}{[\code{list()}]\cr
Optionally marginal distributions for regressors. If not specified,
standard normal marginal distributions are used.

Each list entry must be named according to a regressor label, and the
following distributions are currently supported:
\describe{
\item{discrete distributions}{
\itemize{
\item Poisson: \code{list(type = "poisson", lambda = ...)}
\item categorical: \code{list(type = "categorical", p = c(...))}
}
}
\item{continuous distributions}{
\itemize{
\item normal: \code{list(type = "normal", mean = ..., sd = ...)}
\item uniform: \code{list(type = "uniform", min = ..., max = ...)}
}
}
}}

\item{correlation}{[\code{matrix()}]\cr
A correlation matrix of dimension \code{length(labels)}, where the
\code{(p, q)}-th entry defines the correlation between regressor
\code{labels[p]} and \code{labels[q]}.}

\item{verbose}{[\code{logical(1)}]\cr
Print information about the simulated regressors?}

\item{x}{A \code{\link{choice_data}} or \code{\link{choice_covariates}} object.}
}
\value{
A \code{tibble}.
}
\description{
The \code{choice_covariates} object defines the choice model covariates.
\itemize{
\item \code{generate_choice_covariates()} samples covariates.
\item \code{covariate_names()} gives the covariate names for given \code{choice_effects}.
\item \code{design_matrices()} builds design matrices.
}
}
\section{Design matrices}{

A covariate design matrix contains the choice covariates of a decider at a
choice occasion. It is of dimension \code{J} x \code{P}, where \code{J} is
the number of choice alternatives and \code{P} the number of effects. See
\code{\link{compute_P}} to compute the number \code{P}.
}

\examples{
choice_effects <- choice_effects(
  choice_formula = choice_formula(
    formula = choice ~ price | income | comfort,
    error_term = "probit",
    random_effects = c(
      "price" = "cn",
      "income" = "cn"
    )
  ),
  choice_alternatives = choice_alternatives(J = 3)
)

ids <- generate_choice_identifiers(N = 3, Tp = 2)

choice_covariates <- generate_choice_covariates(
  choice_effects = choice_effects,
  choice_identifiers = ids
)
}
\keyword{data}
