% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_edges.R
\name{geom_edges}
\alias{geom_edges}
\title{Link neighbors by arrow on a chessboard}
\usage{
geom_edges(nodes, focus, neighbors)
}
\arguments{
\item{nodes}{a \code{data.frame} with (at least) the following three columns:
\code{node}, \code{transect}, and \code{quadrats}. Must be the output if the function
\code{\link[=create_node_labels]{create_node_labels()}}.}

\item{focus}{an \code{character} of length 1. The node label to be emphasized on
the chessboard. Must exist in the \code{nodes} object.}

\item{neighbors}{a \code{data.frame} with the following at least three columns:
\code{node}, \code{transect}, and \code{quadrats}. See \code{\link[=pawn]{pawn()}}, \code{\link[=fool]{fool()}}, etc. for
further information.}
}
\value{
A \code{geom_segment} that must be added to a \code{ggplot2} object.
}
\description{
Links neighbors (cells) on a chessboard plotted with \code{\link[=gg_chessboard]{gg_chessboard()}}.
}
\examples{
library("chessboard")

sites_infos <- expand.grid("transect" = 1:9, "quadrat" = 1:9)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect", 
                            quadrat  = "quadrat")

focus <- "5-5"

neighbors <- wizard(nodes, focus = focus, degree = 4, directed = FALSE, 
                    reverse = TRUE)

gg_chessboard(nodes) +
  geom_neighbors(nodes, neighbors) +
  geom_edges(nodes, focus, neighbors) +
  geom_node(nodes, focus)
}
