% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bishop.R
\name{bishop}
\alias{bishop}
\title{Find neighbors according to bishop movement}
\usage{
bishop(
  nodes,
  focus,
  degree = 1,
  directed = FALSE,
  reverse = FALSE,
  self = FALSE
)
}
\arguments{
\item{nodes}{a \code{data.frame} with (at least) the following three columns:
\code{node}, \code{transect}, and \code{quadrats}. Must be the output of the function
\code{\link[=create_node_labels]{create_node_labels()}}.}

\item{focus}{an \code{character} of length 1. The node label for which the
neighbors must be found. Must exist in the \code{nodes} object.}

\item{degree}{an \code{integer} of length 1. The maximum number of neighbors to
search for.}

\item{directed}{a \code{logical} of length 1. If \code{FALSE} (default), search for
neighbors in all directions (undirected network). Otherwise, the network
will be considered as directed according to the orientations of the
network. The default orientation follows the order of node labels in
both axes.}

\item{reverse}{a \code{logical} of length 1. If \code{TRUE}, change the default
orientation of the network. This argument is ignored if \code{directed = FALSE}.
See examples for further detail.}

\item{self}{a \code{logical} of length 1. If \code{TRUE}, a node can be its own
neighbor. Default is \code{FALSE}.}
}
\value{
A subset of the \code{nodes} (\code{data.frame}) where each row is a neighbor
of the focal node.
}
\description{
For one node (argument \code{focus}), finds neighbors among a list of nodes
according to the bishop movement.
This movement is derived from the chess game. The bishop can move along the
two diagonals.

The detection of neighbors using this method can only work with
two-dimensional sampling (both \strong{transects} and \strong{quadrats}).
For sampling of type \strong{transects-only} or \strong{quadrats-only},
please use the functions \code{\link[=fool]{fool()}} or \code{\link[=pawn]{pawn()}}, respectively.
}
\details{
This function is internally called by \code{\link[=create_edge_list]{create_edge_list()}} but it can be
directly used to 1) understand the neighbors detection method, and 2) to
check detected neighbors for one particular node (\code{focus}).
}
\examples{
library("chessboard")

# Two-dimensional sampling (only) ----
sites_infos <- expand.grid("transect" = 1:9, "quadrat" = 1:9)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect", 
                            quadrat  = "quadrat")

focus     <- "5-5"

# Default settings ----
neighbors <- bishop(nodes, focus)
gg_chessboard(nodes) +
  geom_node(nodes, focus) +
  geom_neighbors(nodes, neighbors)

# Higher degree of neighborhood ----
neighbors <- bishop(nodes, focus, degree = 3)
gg_chessboard(nodes) +
  geom_node(nodes, focus) +
  geom_neighbors(nodes, neighbors)
  
# Directed (default orientation) ----
neighbors <- bishop(nodes, focus, degree = 3, directed = TRUE)
gg_chessboard(nodes) +
  geom_node(nodes, focus) +
  geom_neighbors(nodes, neighbors)
  
# Directed (reverse orientation) ----
neighbors <- bishop(nodes, focus, degree = 3, directed = TRUE, 
                    reverse = TRUE)
gg_chessboard(nodes) +
  geom_node(nodes, focus) +
  geom_neighbors(nodes, neighbors)
}
