% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_orders_account.R
\name{get_orders_account}
\alias{get_orders_account}
\title{Get Orders for Specific Account}
\usage{
get_orders_account(
  tokens,
  encrypted_account_id,
  from_entered_datetime = strftime(Sys.time() - lubridate::days(60), format =
    "\%Y-\%m-\%dT\%H:\%M:\%S.000Z"),
  to_entered_datetime = strftime(Sys.time(), format = "\%Y-\%m-\%dT\%H:\%M:\%S.000Z"),
  max_results = NULL,
  status = NULL
)
}
\arguments{
\item{tokens}{token object from `get_authentication_tokens` function (list).}

\item{encrypted_account_id}{encrypted ID of the account from `get_account_numbers` function (string).}

\item{from_entered_datetime}{start of time range for orders that should be gathered - default is current datetime less 60 days (string).}

\item{to_entered_datetime}{end of time range for orders that should be gathered - default is current datetime (string).}

\item{max_results}{maximum number of results to be returned - default is NULL, which is 3000 (numeric).}

\item{status}{only orders of this status should be returned. Default is NULL, which is all statuses. Valid values are "AWAITING_PARENT_ORDER", "AWAITING_CONDITION", "AWAITING_STOP_CONDITION", "AWAITING_MANUAL_REVIEW", "ACCEPTED", "AWAITING_UR_OUT", "PENDING_ACTIVATION", "QUEUED", "WORKING", "REJECTED", "PENDING_CANCEL", "CANCELED", "PENDING_REPLACE", "REPLACED", "FILLED", "EXPIRED", "NEW", "AWAITING_RELEASE_TIME", "PENDING_ACKNOWLEDGEMENT", "PENDING_RECALL", and "UNKNOWN" (string).}
}
\value{
Returns a data frame containing order information
        for the specified account.
}
\description{
Given the tokens object from the `get_authentication_tokens`
function and the encrypted account ID, return a data frame
containing the orders for the specific account.
By default, it will return all orders (default max is 3000)
from the last 60 days. This can be adjusted through
additional function parameters.
}
\details{
The easiest way to enter the right strings in the start/end times is to
begin with `Sys.time()`, use the `lubridate` package to adjust it, and
then format it as `%Y-%m-%dT%H:%M:%S.000Z`. For example, to get the current
date less 30 days, you can use:
`strftime(Sys.time() - lubridate::days(30), format = "%Y-%m-%dT%H:%M:%S.000Z")`.
The defaults for this function illustrate the appropriate usage for the API.
}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, July 2024
}
\keyword{account}
\keyword{orders}
