% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chainbinom.R
\name{dchainbinom}
\alias{dchainbinom}
\alias{rchainbinom}
\alias{echainbinom}
\title{The Chain Binomial distribution}
\usage{
dchainbinom(x, s0, sar, i0 = 1, generations = Inf)

rchainbinom(n, s0, sar, i0 = 1, generations = Inf)

echainbinom(s0, sar, i0 = 1, generations = Inf)
}
\arguments{
\item{x}{numeric vector of the number of infected.}

\item{s0}{the number of initial susceptibles.}

\item{sar}{the secondary attack rate, or the per person risk of infection by an infected.}

\item{i0}{the number of primary cases.}

\item{generations}{the number of generations. Default is Inf, which represents the entire epidemic.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
\code{dchainbinom} gives the probability of x infected, given s0, i0, sar and generations. \code{echainbinom} gives the expected value.
\code{rchainbinom} generates random data.
}
\description{
Probability mass function, expected value, and random generation, for the chain binomial distribution,
with parameters s0, sar, i0, and number of generations, for the number of infected
cases in a population of size s0 after a given number of generations.
}
\examples{
dchainbinom(x = 0:5, s0 = 5, sar = 0.2, i0 = 1, generations = Inf)
rchainbinom(n = 10, s0 = 5, sar = 0.2, i0 = 1, generations = Inf)
echainbinom(s0 = 5, sar = 0.2, i0 = 1, generations = Inf)

}
