% Generated by roxygen2 (4.0.2): do not edit by hand
\name{decay}
\alias{decay}
\title{Find the decay centrality of a given vertex}
\usage{
decay(graph, vids = V(graph), mode = c("all", "out", "in"),
  weights = NULL, decay = 0.5)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{mode}{Character constant, gives whether the shortest paths to or from the given vertices should be calculated for directed graphs. If out then the shortest paths from the vertex, if in then to it will be considered. If all, the default, then the corresponding undirected graph will be used, ie. not directed paths are searched. This argument is ignored for undirected graphs.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is NULL, the default, and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute).}

\item{decay}{A decay parameter which the default is 0.5.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
Decay centrality of a given vertex \eqn{x}{x} of a graph G is define as:
\deqn{\sum_{y \in V(G)}\sigma ^{d(x,y)}}{sum(sigma ^ d(x,y), y in V(G))}
where \eqn{d(x,y)}{d(x,y)} denotes the distance between \eqn{x}{x} and \eqn{y}{y} and \eqn{\sigma \in (0,1)}{sigma in (0,1)} is a parameter.
}
\details{
Decay centrality is a centrality measure based on the proximity between a choosen vertex and every other vertex weighted by the decay. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Decay_Centrality}{Decay Centrality}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2), directed=FALSE)
decay(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Jana Hurajova, Silvia Gago and Tomas Madaras, Decay Centrality, 15th Conference of Kosice Mathematicians. Herl'ny 2.-5. aprila 2014.
}

