% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{censobr_cache}
\alias{censobr_cache}
\title{Manage cached files from the censobr package}
\usage{
censobr_cache(
  list_files = TRUE,
  print_tree = FALSE,
  delete_file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{list_files}{Logical. Whether to print a message with the address of all
censobr data sets cached locally. Defaults to \code{TRUE}.}

\item{print_tree}{Logical. Whether the cache files should be printed in a
tree-like format. This parameter only works if \code{list_files = TRUE}.
Defaults to \code{FALSE}.}

\item{delete_file}{String. The file name or a string pattern that matches the
file path of a file cached locally and which should be deleted.
Defaults to \code{NULL}, so that no file is deleted. If \code{delete_file = "all"},
then all of the cached files are deleted.}

\item{verbose}{A logical. Whether the function should print informative
messages. Defaults to \code{TRUE}.}
}
\value{
A message indicating which file exist and/or which ones have been
deleted from the local cache directory.
}
\description{
Manage cached files from the censobr package
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# list all files cached
censobr_cache(list_files = TRUE)

# delete particular file
censobr_cache(delete_file = '2010_deaths')
\dontshow{\}) # examplesIf}
}
\seealso{
Other Cache data: 
\code{\link{get_censobr_cache_dir}()},
\code{\link{set_censobr_cache_dir}()}
}
\concept{Cache data}
