% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluation}
\alias{evaluation}
\title{Consistent Estimation of the Number of Communities via Regularized Network Embedding.}
\usage{
evaluation(Z.hat, Z.true, cluster.matrix.hat, cluster.matrix.true,
                  P.true, Theta.true, K.hat=4, K.true=4)
}
\arguments{
\item{Z.hat}{A n * r matrix, the estimated embedding vectors corresponding to n nodes.}

\item{Z.true}{A n * r matrix, the true embedding vectors corresponding to n nodes.}

\item{cluster.matrix.hat}{A n * n estimated membership matrix, whose (i,j)-element is 1, if nodes i and j are estimated to belong to the same community, and 0, otherwise.}

\item{cluster.matrix.true}{A n * n true membership matrix, whose (i,j)-element is 1, if nodes i and j belong to the same community, and 0, otherwise.}

\item{P.true}{A n * n true probability matrix.}

\item{Theta.true}{A n * n true matrix: Z.true \%*\% t(Z.true).}

\item{K.hat}{The true number of communities.}

\item{K.true}{The estimated number of communities.}
}
\value{
A vector including five evaluation index.
prop. 1: the estimated and actual number of communities are equal; 0: not equal.
}
\description{
The evaluation function for Consistent Estimation of the Number of Communities via Regularized Network Embedding.
}
\author{
Mingyang Ren.
}
