% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_staged_tree.R
\docType{methods}
\name{Stratified.staged.tree}
\alias{Stratified.staged.tree}
\alias{Stratified.staged.tree,missing,ANY,ANY-method}
\alias{Stratified.staged.tree,ANY,ANY,ANY-method}
\alias{Stratified.staged.tree,data.frame,numeric,numeric-method}
\alias{Stratified.staged.tree,data.frame,numeric,missing-method}
\alias{Stratified.staged.tree,data.frame,missing,missing-method}
\alias{Stratified.staged.tree,Stratified.event.tree,list,ANY-method}
\title{Stratified.staged.tree}
\usage{
Stratified.staged.tree(x, y, z, ...)

\S4method{Stratified.staged.tree}{missing,ANY,ANY}(x, y, z, ...)

\S4method{Stratified.staged.tree}{ANY,ANY,ANY}(x, y, z, ...)


  \S4method{Stratified.staged.tree}{data.frame,numeric,numeric}(x = "data.frame",
  y = 1L, z = 0L)


  \S4method{Stratified.staged.tree}{data.frame,numeric,missing}(x = "data.frame",
  y = 1L)


  \S4method{Stratified.staged.tree}{data.frame,missing,missing}(x = "data.frame")


  \S4method{Stratified.staged.tree}{Stratified.event.tree,list,ANY}(x = "Stratified.event.tree",
  y = "list")
}
\arguments{
\item{x}{(data.frame) is a well behavioured data set or (Stratified.event.tree)}

\item{y}{(numeric) alpha or (list) that represents the stage.structure.
To construct it, the user must plot the Stratified.event.tree graph and use
the labelled number of each node.}

\item{z}{(numeric) variable.order}

\item{...}{(not used)}
}
\value{
a Stratified.staged.tree S4 object
}
\description{
Constructor method to Stratified.staged.tree S4 objects. It accepts different
sets for parameters types.
}
\note{
The implementation admits providing the three arguments, or the first two, or
 even only the data.frame.\cr
 The default variable order is as in the data.frame and the default alpha is
 1L.\cr
 To manualy create a stratified.event.tree from a stratified.event.tree:\cr
 \describe{
 \item{1st}{plot the stratified.event.tree - \code{plot(set)}}
 \item{2nd}{Looking the graph, you can create the stage structure,
 such as: \code{stage.structure <- list(list(c(2,3)), list(c(4,7,12),c(5,8,9)))}}
 \item{3rd}{Finally you can create your Stratified.event.tree:
 \code{st.manual<- Stratified.staged.tree(set, stage.structure)}}
 }

A call to \code{Stratified.staged.tree( )} with no parameters will return
 an error message for missing argument. \cr
A call to \code{Stratified.staged.tree(x, ...)}, x not being a data.frame or
a Event.tree, will return an error message.
}
\examples{
sst <- Stratified.staged.tree(artificial.chds)

stt.manual <- Stratified.staged.tree(set.manual,
list(list(c(2,3)), list(c(4,7,12),c(5,8,9))))

}
