% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_asr.R
\name{plot_asr}
\alias{plot_asr}
\title{Plot Ancestral States Reconstructions}
\usage{
plot_asr(
  x,
  anc = NULL,
  inc = NULL,
  common_colorscale = FALSE,
  x.legend = "topleft",
  y.legend = NULL,
  adj = c(0.5, 0.5),
  piecol = NULL,
  width.node = NULL,
  height.node = NULL,
  width.edge = NULL,
  height.edge = NULL,
  style = "bars",
  offset = 1,
  scaling = 1,
  x.lim = NULL,
  x.intersp = NULL,
  ...
)
}
\arguments{
\item{x}{a \code{\link{cauphylm}} or \code{\link{fitCauchy}} object.}

\item{anc}{(optional) an object of class \code{ancestralCauchy}, obtained with \code{\link{ancestral}}.}

\item{inc}{(optional) an object of class \code{ancestralCauchy}, obtained with \code{\link{increment}}.}

\item{common_colorscale}{If both plotted, should the ancestral states and the increment be represented by the same color scale ? Default to \code{FALSE}.}

\item{x.legend, y.legend}{the x and y co-ordinates to be used to position the legend. They can be specified by keyword or in any way which is accepted by \code{\link[graphics]{legend}}.}

\item{adj}{one or two numeric values specifying the horizontal and
    vertical, respectively, justification of the text or symbols. By
    default, the text is centered horizontally and vertically. If a
    single value is given, this alters only the horizontal position of
    the text.}

\item{piecol}{a list of colours (given as a character vector) to be
    used by \code{thermo} or \code{pie}; if left \code{NULL}, a series
    of colours given by the function \code{rainbow} is used.}

\item{width.node, height.node, width.edge, height.edge}{parameters controlling the aspect of thermometers for the nodes and the edges; by default, their width and height are determined automatically.}

\item{style}{a character string specifying the type of graphics; can
    be abbreviated (see details).}

\item{offset}{offset of the tip labels (can be negative).}

\item{scaling}{the scaling factor to apply to the data.}

\item{x.lim}{a numeric vector of length one or two giving the limit(s)
    of the x-axis. If \code{NULL}, this is computed with respect to
    various parameters such as the string lengths of the labels and the
    branch lengths. If a single value is given, this is taken as the
    upper limit.}

\item{x.intersp}{character interspacing factor for horizontal (x) spacing between symbol and legend text (see \code{\link[graphics]{legend}}).}

\item{...}{other parameters to be passed on to \code{\link[ape]{plot.phylo}} or \code{\link[ape]{phydataplot}}.}
}
\value{
None.
}
\description{
Plot the ancestral states reconstructions from a fitted Cauchy model.
}
\details{
The main plot is done with \code{\link[ape]{plot.phylo}},
the node annotation use \code{\link[ape]{nodelabels}}, and the 
tip data plot use \code{\link[ape]{phydataplot}}.
Please refer to these functions for the details of the parameters.

The width of each color in the thermo plots approximately represents the 
weight of each node of the distribution, that is estimated by numerically 
integrating the density function around each mode.
Function \code{\link[pracma]{findpeaks}} is first used to find the modes and
estimate their starting and ending points.
Then function \code{\link[pracma]{trapz}} estimates the integral of the density
around the mode.

For an exact representation of a node posterior density, please plot it separately,
using function \code{\link{plot.ancestralCauchy}}.
}
\examples{
set.seed(1289)
# Simulate tree and data
phy <- ape::rphylo(10, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy",
                    parameters = list(root.value = 10, disp = 0.1))
# Fit the data
fit <- fitCauchy(phy, dat, model = "cauchy", method = "reml")
# Reconstruct the ancestral states and increments
inc <- increment(fit, n_values = 100)
anc <- ancestral(fit, n_values = 100)
plot_asr(fit, inc = inc, anc = anc, offset = 3,
         width.node = 0.8, height.node = 0.5, 
         width.edge = 1.5, height.edge = 0.2,
         x.legend = "topright")


}
\seealso{
\code{\link{cauphylm}}, \code{\link{fitCauchy}}, \code{\link{ancestral}}, \code{\link{increment}},
\code{\link[ape]{plot.phylo}}, \code{\link[ape]{phydataplot}}, \code{\link[ape]{nodelabels}}
}
