% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_cpdag}
\alias{is_cpdag}
\title{Is the \code{caugi} graph a CPDAG?}
\usage{
is_cpdag(cg)
}
\arguments{
\item{cg}{A \code{caugi} object.}
}
\value{
A logical value indicating whether the graph is a CPDAG.
}
\description{
Checks if the given \code{caugi} graph is a
Complete Partially Directed Acyclic Graph (CPDAG).
}
\examples{
cg_cpdag <- caugi(
  A \%---\% B,
  A \%-->\% C,
  B \%-->\% C,
  class = "PDAG"
)
is_cpdag(cg_cpdag) # TRUE

cg_not_cpdag <- caugi(
  A \%---\% B,
  A \%---\% C,
  B \%-->\% C,
  class = "PDAG"
)
is_cpdag(cg_not_cpdag) # FALSE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
