% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowplaces.R
\name{flowplaces}
\alias{flowplaces}
\title{Computes flow indicators per places}
\usage{
flowplaces(tab, origin = NULL, destination = NULL, fij = NULL, format, x)
}
\arguments{
\item{tab}{is the input flow dataset}

\item{origin}{the place of origin code}

\item{destination}{the place of destination code}

\item{fij}{the flow value between origin and destination places}

\item{format}{specify the flow dataset format, "M " for square matrix [n*n] or "L" for long [i,j,data]}

\item{x}{enter the flowplaces indicator type : "allflowplaces", "ini", "outi", "degi","intra", "Oi", "Dj", voli","bali","asyi". See Details.}
}
\description{
Compute indicators per places (origin and/or destination ) from the margins of the matrix. Ex/ in and out degrees, gross and net flows, asymmetry .... from an initial matrix
}
\details{
This function compute for all pairs or origin-destination places (i,j)
a data table that describes the flows from the point of view of Origin / destination places
- x = "ini" for the number of incoming links (as in-degree) \cr
- x = "outi" for the number of outcoming links (as out-degree)\cr
- x = "degi" for the total number of links (as in and out degrees)\cr
- x = "intra" for total intra zonal interaction (if main diagonal is not empty\cr
- x = "Dj" for the total flows received by (j) place \cr
- x = "voli" for the total volume of flow per place \cr
- x = "bali" for the net balance of flow per place \cr
- x = "asyi" for the asymetry of flow per place \cr
- x = "allflowplaces" for computing all the above indicators\cr
}
\examples{
library(cartograflow)
data(flowdata)
bkg <- system.file("shape/MGP_TER.shp",
  package = "cartograflow",
  lib.loc = NULL, mustWork = TRUE)

###1:Computes the total flow volume of places : Long format
voli <- flowplaces(flows, origin ="i",destination="j",fij="Fij",format = "L", x = "voli")
###2:Computes the total flows received by destination place : Long format
tab_bali <- flowplaces(flows, origin ="i",destination="j",fij="Fij",format = "L", x = "bali")
}
