% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{intcal13}
\alias{intcal13}
\title{IntCal13 calibration curve}
\format{
\subsection{\code{intcal13}}{

A data frame with 5,141 rows and 5 columns providing the IntCal13 radiocarbon age
calibration curve on a calendar grid spanning from 50,000--0 cal yr BP:
\describe{
\item{calendar_age}{The calendar age (in cal yr BP)}
\item{c14_age}{The \eqn{{}^{14}}C age (in \eqn{{}^{14}}C yr BP)}
\item{c14_sig}{The (1-\eqn{\sigma}) uncertainty in the \eqn{{}^{14}}C age}
\item{f14c}{The \eqn{{}^{14}}C age expressed as F\eqn{{}^{14}}C concentration}
\item{f14c_sig}{The (1-\eqn{\sigma}) uncertainty in the F\eqn{{}^{14}}C concentration}
}
}
}
\source{
http://doi.org/10.2458/azu_js_rc.55.16947
}
\usage{
intcal13
}
\description{
The IntCal13 Northern Hemisphere radiocarbon age calibration curve
on a calendar grid spanning from 50,000--0 cal yr BP
(Before Present, 0 cal yr BP corresponds to 1950 CE). \cr \cr
\emph{Note:} This dataset provides \eqn{{}^{14}}C ages and F\eqn{{}^{14}}C values
on a calendar age grid. This is different from the \eqn{{}^{14}}C ages
and \eqn{{\Delta}^{14}}C values provided in oxcal .14c files.\cr \cr
\strong{Reference:} \cr Reimer PJ, Bard E, Bayliss A, Beck JW, Blackwell PG, Bronk Ramsey C, Buck CE,
Cheng H, Edwards RL, Friedrich M, Grootes PM, Guilderson TP, Haflidason H,
Hajdas I, Hatt? C, Heaton TJ, Hogg AG, Hughen KA, Kaiser KF, Kromer B,
Manning SW, Niu M, Reimer RW, Richards DA, Scott EM, Southon JR, Turney CSM,
van der Plicht J. 2013.
IntCal13 and Marine13 radiocarbon age calibration curves 0--50000 years calBP.
\emph{Radiocarbon} \strong{55}(4) https://doi.org/10.2458/azu_js_rc.55.16947. \cr \cr
}
\keyword{datasets}
