% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{weightedVarRcppN}
\alias{weightedVarRcppN}
\title{Estimate weighted variance}
\usage{
weightedVarRcppN(y, w)
}
\arguments{
\item{y}{Response. The mean of the response contains weights (numeric vector).}

\item{w}{Weights for averaging (numeric vector).}
}
\value{
Weighted variance (numeric scalar).
}
\description{
Efficient C implementation of the sample variance estimator. 
The denominator is defined as the sample size.
}
\note{
There are no safety checks of input arguments.
}
\examples{
# Simulate a random vector
set.seed(3975)
x <- rnorm(100)
# Calculate variance with standard implementation
varEst <- var(x) * (100-1) / 100
# Calculate weighted variance with equal weights
equalW <- rep(1, 100)
weightVarEst <- weightedVarRcppN(y=x, w=equalW)
# Output comparison
all.equal(varEst, weightVarEst)
# Runtime comparison
library(microbenchmark)
microbenchmark(Default=var(x), New=weightedVarRcppN(y=x, w=equalW), times=25)
# -> New method is multiple times faster
}
\author{
Thomas Welchowski
}
\keyword{survival}
