% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{weightedCovarRcppN}
\alias{weightedCovarRcppN}
\title{Estimate weighted covariance}
\usage{
weightedCovarRcppN(x, y, w)
}
\arguments{
\item{x}{Covariate without weighting (numeric vector).}

\item{y}{Response. The mean of the response contains weights (numeric vector).}

\item{w}{Weights for averaging (numeric vector).}
}
\value{
Weighted variance (numeric scalar).
}
\description{
Efficient C implementation of the sample covariance estimator. 
The denominator is defined as the sample size.
}
\note{
There are no safety checks of input arguments.
}
\examples{
# Simulate two random vectors
set.seed(3975)
x <- rnorm(100)
set.seed(-3975)
y <- rnorm(100)
# Calculate variance with standard R function
# Rescaling ensures that both calculations use same denominator "n"
covarEst <- cov(x, y) * (100-1) / 100
# Calculate weighted variance with equal weights
equalW <- rep(1, 100)
weightCovarEst <- weightedCovarRcppN(x=x, y=y, w=equalW)
# Output comparison
all.equal(covarEst, weightCovarEst)
# Runtime comparison
library(microbenchmark)
microbenchmark(Default=cov(x, y), New=weightedCovarRcpp(x=x, y=y, w=equalW), times=25)
# -> New method is multiple times faster
}
\author{
Thomas Welchowski
}
\keyword{survival}
