% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capushe.R
\docType{methods}
\name{plot-methods}
\alias{plot-methods}
\alias{plot,Capushe-method}
\alias{plot,DDSE-method}
\alias{plot,Djump-method}
\alias{plot}
\alias{plot.capushe}
\alias{plot.DDSE}
\alias{plot.Djump}
\alias{plotcapushe}
\alias{plotDDSE}
\alias{plotDjump}
\title{Plot for capushe}
\usage{
plot(x,y, ...)
}
\arguments{
\item{x}{Output of \code{\link[=DDSE]{DDSE}}, \code{\link[=Djump]{Djump}} or \code{\link[=capushe]{capushe}}.}

\item{...}{other arguments :
\itemize{
  \item newwindow If \code{newwindow}=\code{TRUE} (default value), a new window is created for each
plot.
  \item ask If \code{ask}=\code{TRUE} (default value), \code{plot} waits for the user to press a
key to display the next plot (only for the class \code{capushe}).
}}

\item{y}{is unused.}
}
\description{
The plot methods allow the user to check that the slope heuristics can be applied confidently.

\itemize{
\item \code{signature(x = "Capushe")} This graphical function displays the \code{DDSE} plot and the \code{Djump} plot.
\item \code{signature(x = "DDSE")} This graphical function displays the \code{\link[=DDSE]{DDSE}} plot.
\item \code{signature(x = "Djump")} This graphical function displays the \code{\link[=Djump]{Djump}} plot.
}
}
\details{
The graphical window of \code{DDSE} is composed of three graphics (see \code{\link[=DDSE]{DDSE}} for more details):
\describe{
  \item{left}{The left plot shows \eqn{-\gamma_n(\hat{s}_m)} with respect to the
    penalty shape values.}
  \item{topright}{Successive slope values \eqn{\hat{\kappa}(p)}.}
  \item{bottomright}{The bottomright plot shows the selected models \eqn{\hat{m}(p)} with respect
    to the successive slope values. The plateau in blue is selected.}
    }
The graphical window of \code{Djump} shows the complexity  \eqn{C_{m(\kappa)}} of
the selected model with respect to \eqn{\kappa}. \eqn{\hat{\kappa}^{dj}} corresponds
to the greatest jump. \eqn{\kappa_{opt}} is defined by \eqn{\kappa_{opt}=scoef\times \hat{\kappa}^{dj}}.
The red line represents the slope interval computed by the \code{DDSE} algorithm
(only for \code{capushe}). See \code{\link[=Djump]{Djump}} for more details.
}
\note{
Use \code{newwindow}=\code{FALSE} to produce a PDF files (for an object of class \code{capushe}, use moreover \code{ask}=\code{FALSE}).
}
\keyword{methods}
