% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_vectors.R
\name{get_cansim_data_for_table_coord_periods}
\alias{get_cansim_data_for_table_coord_periods}
\title{Retrieve data for specified Statistics Canada data product for last N periods for specific coordinates}
\usage{
get_cansim_data_for_table_coord_periods(
  tableCoordinates,
  periods = NULL,
  language = "english",
  refresh = FALSE,
  timeout = 200,
  factors = TRUE,
  default_month = "07",
  default_day = "01"
)
}
\arguments{
\item{tableCoordinates}{Either a list with vectors of coordinates by table number, or a
(filtered) data frame as returned by \code{get_cansim_table_template}.}

\item{periods}{Optional numeric value for number of latest periods to retrieve data for, default is \code{NULL} in which case data for all periods is downloaded.
Alternatively this can be specified by
coordinate if tableCoordinates is a data frame, this argument will be ignored if that data frame as a "periods" column.}

\item{language}{\code{"eng"} or \code{"english"} for English and \code{"fra"} or \code{"french"} for French language versions (defaults to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}

\item{factors}{(Optional) Logical value indicating if dimensions should be converted to factors. (Default set to \code{TRUE}).}

\item{default_month}{The default month that should be used when creating Date objects for annual data (default set to "07")}

\item{default_day}{The default day of the month that should be used when creating Date objects for monthly data (default set to "01")}
}
\value{
A tibble with data matching specified coordinate and period input arguments
}
\description{
Allows for the retrieval of data for a Statistics Canada data table with specific table and coordinates.
This allows partial targeted download of tables and can be effectively combined with the \code{get_cansim_table_template}
function to help pinpoint data series of interest.
The StatCan API can only process 300 coordinates at a time,
if more than 300 coordinates are specified the function will batch the requests to the API.
}
\examples{
\dontrun{
get_cansim_data_for_table_coord_periods(list("35-10-0003"=c("1.1","1.12")),periods=3)
}
}
