% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_suite.R
\name{get_statcan_geographic_attributes}
\alias{get_statcan_geographic_attributes}
\title{Read the Geographic Attributes File}
\usage{
get_statcan_geographic_attributes(census_year = "2021", refresh = FALSE)
}
\arguments{
\item{census_year}{census year to get the data for, right now only 2006, 2011, 2016, 2021 are supported}

\item{refresh}{(logical) refresh the cache if true}
}
\value{
tibble with the relationship data
}
\description{
Reads the Geographies Attributes File for the given census year. The table contains
the information on how all the geographic levels are related for each area, and population, dwelling and household counts.
Data gets cached after first download if the
cancensus cache path has been set. A reference guide is available
at https://www150.statcan.gc.ca/n1/en/catalogue/92-151-G2021001
}
\examples{
# list add the cached census data
\dontrun{
get_statcan_geographic_attributes("2021")
}
}
