% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-city.R
\name{check_city}
\alias{check_city}
\title{Check whether an input is a valid place with Google Maps API}
\usage{
check_city(city = NULL, state = NULL, zip = NULL, key = NULL, guess = FALSE)
}
\arguments{
\item{city}{A string of city name to be submitted to the Geocode API.}

\item{state}{Optional. The state associated with the \code{city}.}

\item{zip}{Optional. Supply a string of ZIP code to increase precision.}

\item{key}{A character string to be passed into \code{key}. Save your key as
"GEOCODE_KEY" using \code{Sys.setenv()} or by editing your \code{.Renviron} file.}

\item{guess}{logical; Should the function return a single row tibble
containing the original data sent and the multiple components returned by
the Geocode API.}
}
\value{
A logical value by default. If the city returned by the API
comes back the same as the city input, the function will evaluate to
\code{TRUE}, in all other circumstances (including API errors) \code{FALSE} is returned.

If the the \code{guess} argument is set to \code{TRUE}, a tibble with 1 row and six
columns is returned:
\itemize{
\item \code{original_city}: The \code{city} value sent to the API.
\item \code{original_state}: The \code{state} value sent to the API.
\item \code{original_zip}: The \code{zip} value sent to the API.
\item \code{check_city_flag}: logical; whether the guessed city matches.
\item \code{guess_city}: The legal city guessed by the API.
\item \code{guess_place}: The generic locality guessed by the API.
}
}
\description{
Check whether a place is a valid place or misspelling by matching against the
Google Geocoding search result. Use the \code{\link[httr:GET]{httr::GET()}} to send a request to
the Google Maps API for geocoding information. The query will concatenate all
the geographical information that is passed in into a long string. Then the
function pulls the \code{formatted_address} endpoint of the API results and then
identifies and extracts the long name field from the API \emph{locality} result
and compare it against the input to see if the input and output match up.
Note that you will need to pass in your Google Maps Place API key to the
\code{key} argument.
}
\seealso{
\url{https://developers.google.com/maps/documentation/geocoding/overview?csw=1}

Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
