% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Fit model to data}
\usage{
fit_model(data, model_function, optimizer_options, file = NULL, ...)
}
\arguments{
\item{data}{A numeric vector containing data to fit model against.}

\item{model_function}{A function that runs the model and
returns data.frame of value, organized as in \code{data}.}

\item{optimizer_options}{A list with options for the
optimizer, as returned by \link{get_optimizer_opts}.}

\item{file}{A path to save the model fit. If the arguments
to the fit call are found to be identical to those in the file,
the model just gets loaded.}

\item{...}{Extra parameters passed to the optimizer call.}
}
\value{
A \linkS4class{CalmrFit} object
}
\description{
Obtain MLE estimates for model, given data.
}
\note{
See the calmr_fits vignette for examples
}
\examples{
# Make some fake data
df <- data.frame(g = "g", p1 = "!3A>(US)")
pars <- get_parameters(df, model = "RW1972")
pars$alphas["US"] <- 0.9
exper <- make_experiment(df, parameters = pars, model = "RW1972")
res <- run_experiment(exper, outputs = "responses")
responses <- results(res)$responses$value

# define model function
model_fun <- function(p, ex) {
  np <- parameters(ex)
  np[[1]]$alphas[] <- p
  parameters(ex) <- np
  results(run_experiment(ex))$responses$value
}

# Get optimizer options
optim_opts <- get_optimizer_opts(
  model_pars = names(pars$alphas),
  ll = rep(.05, 2), ul = rep(.95, 2),
  optimizer = "optim", family = "identity"
)
optim_opts$initial_pars[] <- rep(.6, 2)

fit_model(responses, model_fun, optim_opts,
  ex = exper, method = "L-BFGS-B",
  control = list(maxit = 1)
)
}
\seealso{
\code{\link[=get_optimizer_opts]{get_optimizer_opts()}}
}
