% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ebmtcal_cmprsk}
\alias{ebmtcal_cmprsk}
\title{European Group for Blood and Marrow Transplantation data (one row per individual)}
\format{
\subsection{'ebmtcal_cmprsk'}{

A data frame with 2,279 rows and 17 columns:
\describe{
\item{id}{Patient indentifier}
\item{rec, rec.s}{Time until and event indicator for recovery variable}
\item{ae, ae.s}{Time until and event indicator for adverse event variable}
\item{recae, recae.s}{Time until and event indicator for recovery + adverse event variable}
\item{rel, rel.s}{Time until and event indicator for relapse variable}
\item{srv, srv.s}{Time until and event indicator for death variable}
\item{year}{Year of transplant}
\item{agecl}{Age at transplant}
\item{proph}{Prophylaxis}
\item{match}{Donor-recipient match}
\item{dtcens}{Time of censoring}
\item{dtcens_s}{Event indicator, 1:censoring occured, 0: absorbing state entered before censoring occured}
}
}
}
\source{
This dataset was derived from data made available within the \code{mstate} package, see \code{\link[mstate]{ebmt4}}.
The data was originally provided by the European Group for Blood and Marrow Transplantation (https://www.ebmt.org/).
We reiterate the source statement given by the developers of \code{mstate}:
"We acknowledge the European Society for Blood and Marrow Transplantation (EBMT)
for making available these data. Disclaimer: these data were simplified for the
purpose of illustration of the analysis of competing risks and multi-state models
and do not reflect any real life situation. No clinical conclusions should be
drawn from these data."
}
\usage{
ebmtcal_cmprsk
}
\description{
Used in vignette/article: Comparison-with-graphical-calibration-curves-in-competing-risks-setting.
}
\details{
A data frame of 2,279 individuals with blood cancer who have undergone a transplant.
This data is identical to the \code{\link[mstate]{ebmt4}} data, except two extra variables have
been derived, time until censoring and a censoring indicator, which are required
to assess calibration using some of the methods in \code{calibmsm}. Specifically, the
time until censoring ar calculated in the setting of a competing risks model out of the
first state, where no further transitions can be made. This means entry into any
state (as they are all absorbing states) will have the effect of preventing censoring
from occurring, and \code{dtcens} and \code{dtcens_s} will be different than the values found
in \code{\link{ebmtcal}}. This dataset has been designed to be used alongside
dataset \code{\link{msebmtcal_cmprsk}}, when assessing the calibration of a competing
risks model. Code for the derivation of this dataset is provided in the source code for the package.
}
\references{
EBMT (2023). “Data from the European Society for Blood and Marrow Transplantation.”
URL https://search.r-project.org/CRAN/refmans/mstate/html/EBMT-data.html.

de Wreede LC, Fiocco M, Putter H (2011). “mstate: An R Package for the Analysis of
Competing Risks and Multi-State Models.” \emph{Journal of Statistical Software}, 38(7).
}
\keyword{datasets}
