% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bvarlist.R
\name{summary.bvarlist}
\alias{summary.bvarlist}
\title{Summarising Bayesian VAR or VEC Models}
\usage{
\method{summary}{bvarlist}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"bvar"}, usually, a result of a call to
\code{\link{draw_posterior}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{summary.bvarlist} returns a table of class \code{"summary.bvarlist"}.
}
\description{
summary method for class \code{"bvarlist"}.
}
\details{
The log-likelihood for the calculation of the information criteria is obtained by
\deqn{LL = \frac{1}{R} \sum_{i = 1}^{R} \left( \sum_{t = 1}^{T} -\frac{K}{2} \ln 2\pi - \frac{1}{2} \ln |\Sigma_t^{(i)}| -\frac{1}{2} (u_t^{{(i)}\prime} (\Sigma_t^{(i)})^{-1} u_t^{(i)} \right)},
where \eqn{u_t = y_t - \mu_t}. The Akaike, Bayesian and Hannan–Quinn (HQ) information criteria are calculated as
\deqn{AIC = 2 (Kp + Ms + N) - 2 LL},
\deqn{BIC = (Kp + Ms + N) ln(T) - 2 LL} and 
\deqn{HQ = 2  (Kp + Ms + N) ln(ln(T)) - 2 LL}, respectively,
where \eqn{K} is the number of endogenous variables, \eqn{p} the number of lags of endogenous variables,
\eqn{M} the number of exogenous variables, \eqn{s} the number of lags of exogenous variables,
\eqn{N} the number of deterministic terms and \eqn{T} the number of observations.
}
