\name{sim.var1.sv.tvp}
\alias{sim.var1.sv.tvp}
\title{
Simulate from a VAR(1) with Stochastic Volatility and Time-Varying Parameters
}
\description{
Simulate from a VAR(1) with Stochastic Volatility and Time-Varying Parameters
}
\usage{
sim.var1.sv.tvp(B0 = NULL, A0 = NULL, Sig0 = NULL, Q = NULL, 
S = NULL, W = NULL, t = 500, init = 1000)
}
\arguments{
  \item{B0}{Initial values of mean parameters: Matrix of dimension \eqn{[M, M+1]}, where the first column holds the intercept vector and the other columns hold the matrix of first-order autoregressive coefficients. By default (NULL), \code{B0} corresponds to \eqn{M = 2} uncorrelated zero-mean processes with moderate persistence (first-order autocorrelation of \eqn{0.6}).}
  \item{A0}{Initial values for (transformed) error correlation parameters: Vector of length \eqn{0.5*M*(M-1)}. Defaults to a vector of zeros.}
  \item{Sig0}{Initial values for log error term volatility parameters: Vector of length \eqn{M}. Defaults to a vector of zeros.}
  \item{Q, S, W}{Covariance matrices for the innovation terms in the time-varying parameters (\eqn{B, A, Sig}). The matrices are symmetric, with dimensions equal to the number of elements in \eqn{B, A} and \eqn{Sig}, respectively. Default to diagonal matrices with very small terms (\code{1e-10}) on the main diagonal. This corresponds to essentially no time variation in the parameters and error term matrix elements.}
  \item{t}{Number of time periods to simulate.}
  \item{init}{Number of draws to initialize simulation (to decrease the impact of starting values).}
}
\value{
  
  \item{data}{Simulated data, with rows corresponding to time and columns corresponding to the \eqn{M} system variables.}
  \item{Beta}{Array of dimension \eqn{[M, M+1, t]}. Submatrix \eqn{[,,l]} holds the parameter matrix for time period \eqn{l}.}
  \item{H}{Array of dimension \eqn{[M, M, t]}. Submatrix \eqn{[,,l]} holds the error term covariance matrix for period \eqn{l}.}
}
\references{
Primiceri, G.E. (2005): `Time Varying Structural Vector Autoregressions and Monetary Policy', Review of Economic Studies 72, 821-852.
}
\author{
Fabian Krueger
}
\examples{
\dontrun{

# Generate data from a model with moderate time variation in the parameters 
# and error term variances
set.seed(5813)
sim <- sim.var1.sv.tvp(Q = 1e-5*diag(6), S = 1e-5*diag(1), W = 1e-5*diag(2))
# Plot both series
matplot(sim$data, type = "l")
# Plot AR(1) parameters of both equations
matplot(cbind(sim$Beta[1,2,], sim$Beta[2,3,]), type = "l")

}
}
\note{The choice of `reasonable' values for the elements of \code{Q}, \code{S} and \code{W} requires some care. If the elements of these matrices are too large, parameter variation can easily become excessive. Too large elements of \code{Q} can lead the parameter matrix \eqn{B} into regions which correspond to explosive processes. Too large elements in \code{S} and (especially) \code{W} may lead to excessive error term variances.}
\seealso{\code{\link{bvar.sv.tvp}} can be used to fit a model on data generated by \code{\link{sim.var1.sv.tvp}}. This can be a useful way to analyze the performance of the estimation methods.}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{forecasting methods}
