% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elnet.R
\name{axe-elnet}
\alias{axe-elnet}
\alias{axe_call.elnet}
\title{Axing an elnet.}
\usage{
\method{axe_call}{elnet}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed model object.
}
\description{
elnet objects are created from the \pkg{glmnet} package, leveraged
to fit generalized linear models via penalized maximum likelihood.
}
\examples{
\dontshow{if (rlang::is_installed("glmnet")) withAutoprint(\{ # examplesIf}
# Load libraries
library(parsnip)
library(rsample)

# Load data
split <- initial_split(mtcars, prop = 9/10)
car_train <- training(split)

# Create model and fit
elnet_fit <- linear_reg(mixture = 0, penalty = 0.1) |>
  set_engine("glmnet") |>
  fit_xy(x = car_train[, 2:11], y = car_train[, 1, drop = FALSE])

out <- butcher(elnet_fit, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
