% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_excel_workbook.R
\name{read_excel_workbook}
\alias{read_excel_workbook}
\title{Import data from multiple sheets of an Excel workbook}
\usage{
read_excel_workbook(path, col_types = NULL, .id = NULL)
}
\arguments{
\item{path}{Path to the xls/xlsx file.}

\item{col_types}{Either \code{NULL} to guess all from the spreadsheet or a
character vector containing one entry per column from these options:
"skip", "guess", "logical", "numeric", "date", "text" or "list". If exactly
one \code{col_type} is specified, it will be recycled. The content of a cell in
a skipped column is never read and that column will not appear in the data
frame output. A list cell loads a column as a list of length 1 vectors,
which are typed using the type guessing logic from \code{col_types = NULL}, but
on a cell-by-cell basis.}

\item{.id}{The name of an optional identifier column. Provide a string to
create an output column that identifies each input. The column will use
names if available, otherwise it will use positions.}
}
\value{
A \link[tibble:tibble-package]{tibble}. If there is any column type mismatch during data frames row binding, an error will occur. This is because R cannot combine columns of different types. For example, you cannot combine a column of integers with a column of characters.
}
\description{
\code{read_excel_workbook()} reads all the data from the sheets of an Excel workbook and return an appended dataframe.
}
\examples{

path <- system.file("extdata", "Diamonds.xlsx", package = "bulkreadr", mustWork = TRUE)

read_excel_workbook(path = path, .id = "Year")


# Column types mismatch error --------------------------------------
# If the `read_excel_workbook()` function complains about a data type mismatch,
# then set the `col_types` argument to `"text"`.
# This will make all the column types in the resulting DataFrame be characters.

}
\seealso{
\code{\link[readxl:read_excel]{readxl::read_excel()}}, which reads a Sheet of an Excel file into a data frame, and \code{\link[=read_gsheets]{read_gsheets()}}, which imports data from multiple sheets in a Google Sheets.
}
