% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfactor.R
\name{bayesianFactor}
\alias{bayesianFactor}
\title{Create a Bayesian Synthetic Control Object Using Panel Data}
\value{
vizdraws object with the relative bias with offset.
}
\description{
A Bayesian Factor Model has raw data and draws from the posterior
distribution. This is represented by an R6 Class.

Code and theory based on
\href{https://arxiv.org/abs/2103.16244}{Pinkney 2021}.

public methods:
\itemize{
\item \code{initialize()} initializes the variables and model parameters
\item \code{fit()}  fits the stan model and returns a fit object
\item \code{updateWidth} updates the width of the credible interval
\item \code{placeboPlot} generates a counterfactual placebo plot
\item \code{effectPlot} returns a plot of the treatment effect over time
\item \code{summarizeLift}returns descriptive statistics of the lift estimate
\item \code{biasDraws} returns a plot of the relative bias in a LFM
\item \code{liftDraws} returns a plot of the posterior lift distribution
\item \code{liftBias} returns a plot of the relative bias given a lift offset
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{timeTiles}}{ggplot2 object that shows when
the intervention happened.}

\item{\code{plotData}}{tibble with the observed outcome and the
counterfactual data.}

\item{\code{interventionTime}}{returns the intervention time period.}

\item{\code{synthetic}}{ggplot2 object that shows the
observed and counterfactual outcomes over time.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-bayesianFactor-new}{\code{bayesianFactor$new()}}
\item \href{#method-bayesianFactor-fit}{\code{bayesianFactor$fit()}}
\item \href{#method-bayesianFactor-updateWidth}{\code{bayesianFactor$updateWidth()}}
\item \href{#method-bayesianFactor-summarizeLift}{\code{bayesianFactor$summarizeLift()}}
\item \href{#method-bayesianFactor-effectPlot}{\code{bayesianFactor$effectPlot()}}
\item \href{#method-bayesianFactor-liftDraws}{\code{bayesianFactor$liftDraws()}}
\item \href{#method-bayesianFactor-liftBias}{\code{bayesianFactor$liftBias()}}
\item \href{#method-bayesianFactor-biasDraws}{\code{bayesianFactor$biasDraws()}}
\item \href{#method-bayesianFactor-clone}{\code{bayesianFactor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-new"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-new}{}}}
\subsection{Method \code{new()}}{
Create a new bayesianFactor object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$new(
  data,
  time,
  id,
  treated,
  outcome,
  ci_width = 0.75,
  covariates
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Long data.frame object with fields outcome, time, id,
and treatment indicator.}

\item{\code{time}}{Name of the variable in the data frame that}

\item{\code{id}}{Name of the variable in the data frame that
identifies the units (e.g. country, region etc).}

\item{\code{treated}}{Name of the variable in the data frame that contains the
treatment assignment of the intervention.}

\item{\code{outcome}}{Name of the outcome variable.}

\item{\code{ci_width}}{Credible interval's width.  This number is in the
(0,1) interval.}

\item{\code{covariates}}{Dataframe with a column for id and the other columns
Defaults to NULL if no covariates should be included in the model.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
params described in the data structure section of the
documentation of the R6 class at the top of the file.
}

\subsection{Returns}{
A new \code{bayesianFactor} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-fit"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-fit}{}}}
\subsection{Method \code{fit()}}{
Fit Stan model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$fit(L = 8, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{L}}{Number of factors.}

\item{\code{...}}{other arguments passed to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-updateWidth"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-updateWidth}{}}}
\subsection{Method \code{updateWidth()}}{
Update the width of the credible interval.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$updateWidth(ci_width = 0.75)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ci_width}}{New width for the credible interval. This number
should be in the (0,1) interval.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-summarizeLift"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-summarizeLift}{}}}
\subsection{Method \code{summarizeLift()}}{
summarizeLift returns descriptive statistics of
the lift estimate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$summarizeLift()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-effectPlot"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-effectPlot}{}}}
\subsection{Method \code{effectPlot()}}{
effectPlot returns ggplot2 object that shows the
effect of the intervention over time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$effectPlot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-liftDraws"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-liftDraws}{}}}
\subsection{Method \code{liftDraws()}}{
Plots lift.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$liftDraws(from, to, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{First period to consider when calculating lift. If infinite,
set to the time of the intervention.}

\item{\code{to}}{Last period to consider when calculating lift. If infinite, set
to the last period.}

\item{\code{...}}{other arguments passed to vizdraws::vizdraws().}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
vizdraws object with the posterior distribution of the lift.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-liftBias"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-liftBias}{}}}
\subsection{Method \code{liftBias()}}{
Plot bias magnitude in terms of lift for period (firstT, lastT)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$liftBias(firstT, lastT, offset, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{firstT}}{Start of the time period to compute relative bias over.
Must be after the intervention.}

\item{\code{lastT}}{End of the time period to compute relative bias over.
Must be after the intervention.
over. They must be after the intervention.}

\item{\code{offset}}{Target lift \%.}

\item{\code{...}}{other arguments passed to vizdraws::vizdraws().}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-biasDraws"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-biasDraws}{}}}
\subsection{Method \code{biasDraws()}}{
Plots relative upper bias / tau for a time period (firstT, lastT).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$biasDraws(small_bias = 0.3, firstT, lastT)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{small_bias}}{Threshold value for considering the bias "small".}

\item{\code{firstT, lastT}}{Time periods to compute relative bias over, they must
after the intervention.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
vizdraw object with the posterior distribution of relative bias.
Bias is scaled by the time periods.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bayesianFactor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-bayesianFactor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bayesianFactor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
