% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_describe_repo.R
\name{bs_describe_repo}
\alias{bs_describe_repo}
\title{Describe a repo}
\usage{
bs_describe_repo(
  repo,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{repo}{Character, length 1. The handle or DID of the repo.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of record information
}
\description{
Describe a repo
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/describeRepo.json}{repo/describeRepo.json (2023-11-25)}
}

\section{Function introduced}{

\code{v0.1.0} (2023-11-25)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_describe_repo('chriskenny.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{repo}
