% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_and_get_object.R
\name{getNsObject}
\alias{getNsObject}
\title{Check and Get Namespace Object If Exists}
\usage{
getNsObject(object, namespace = NULL, envir = NULL)
}
\arguments{
\item{object}{A symbol representing the object to be retrieved. The input
must be a symbol (i.e., not a character string) corresponding to an
existing object within the specified namespace.}

\item{namespace}{A character string specifying the namespace to check for the
object. If the object exists within the given namespace, it will be
returned.}

\item{envir}{An environment in which to search for the object. If set to
\code{NULL} (default), the function uses the global environment.}
}
\value{
The object of the same class as the input \code{object}, if it
exists. If the object doesn't exist in the specified namespace or
environment, an error is raised.
}
\description{
This function checks if an object exists within a specified namespace and
returns the object if it exists. The object must be provided as a symbol
(not a character string). The function is designed to facilitate the
retrieval of model or other objects from a specified environment or
namespace. This function is mainly for internal purposes.
}
\examples{

\donttest{
# Check whether model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)
}

}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
