% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_summaries.R
\name{b_min}
\alias{b_min}
\alias{b_summaries}
\alias{b_max}
\alias{b_median}
\alias{b_mean}
\alias{b_q25}
\alias{b_q75}
\alias{b_range}
\alias{b_range_diff}
\alias{b_sd}
\alias{b_var}
\alias{b_mad}
\alias{b_iqr}
\alias{b_diff_var}
\alias{b_diff_sd}
\alias{b_diff_mean}
\alias{b_diff_median}
\alias{b_diff_q25}
\alias{b_diff_q75}
\alias{b_diff_max}
\alias{b_diff_min}
\alias{b_diff_iqr}
\title{Brolgar summaries (b_summaries)}
\usage{
b_min(x, ...)

b_max(x, ...)

b_median(x, ...)

b_mean(x, ...)

b_q25(x, ...)

b_q75(x, ...)

b_range(x, ...)

b_range_diff(x, ...)

b_sd(x, ...)

b_var(x, ...)

b_mad(x, ...)

b_iqr(x, ...)

b_diff_var(x, ...)

b_diff_sd(x, ...)

b_diff_mean(x, ...)

b_diff_median(x, ...)

b_diff_q25(x, ...)

b_diff_q75(x, ...)

b_diff_max(x, ...)

b_diff_min(x, ...)

b_diff_iqr(x, ...)
}
\arguments{
\item{x}{a vector}

\item{...}{other arguments to pass}
}
\description{
Customised summaries of vectors with appropriate defaults for longitudinal
data. The functions are prefixed with \code{b_} to assist with autocomplete.
It uses \code{na.rm = TRUE} for all, and for calculations
involving quantiles, \code{type = 8} and \code{names = FALSE}. Summaries include:
* b_min: The minimum
* b_max: The maximum
* b_median: The median
* b_mean: The mean
* b_q25: The 25th quantile
* b_q75: The 75th quantile
* b_range: The range
* b_range_diff: difference in range (max - min)
* b_sd: The standard deviation
* b_var: The variance
* b_mad: The mean absolute deviation
* b_iqr: The Inter-quartile range
* b_diff_var: The variance diff()
* b_diff_sd: The standard deviation of diff()
* b_diff_mean: The mean of diff()
* b_diff_median: The median of diff()
* b_diff_q25: The q25 of diff()
* b_diff_q75: The q75 of diff()
}
\examples{

x <- c(1:5, NA, 5:1)
min(x)
b_min(x)
max(x)
b_max(x)
median(x)
b_median(x)
mean(x)
b_mean(x)
range(x)
b_range(x)
var(x)
b_var(x)
sd(x)
b_sd(x)

}
