% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_samples.R
\name{posterior_samples.brmsfit}
\alias{posterior_samples.brmsfit}
\alias{posterior_samples}
\title{(Deprecated) Extract Posterior Samples}
\usage{
\method{posterior_samples}{brmsfit}(
  x,
  pars = NA,
  fixed = FALSE,
  add_chain = FALSE,
  subset = NULL,
  as.matrix = FALSE,
  as.array = FALSE,
  ...
)

posterior_samples(x, pars = NA, ...)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}}

\item{pars}{Names of parameters for which posterior samples
should be returned, as given by a character vector or regular expressions.
By default, all posterior samples of all parameters are extracted.}

\item{fixed}{Indicates whether parameter names
should be matched exactly (\code{TRUE}) or treated as
regular expressions (\code{FALSE}). Default is \code{FALSE}.}

\item{add_chain}{A flag indicating if the returned \code{data.frame}
should contain two additional columns. The \code{chain} column
indicates the chain in which each sample was generated, the \code{iter}
column indicates the iteration number within each chain.}

\item{subset}{A numeric vector indicating the rows
(i.e., posterior samples) to be returned.
If \code{NULL} (the default), all  posterior samples are returned.}

\item{as.matrix}{Should the output be a \code{matrix}
instead of a \code{data.frame}? Defaults to \code{FALSE}.}

\item{as.array}{Should the output be an \code{array}
instead of a \code{data.frame}? Defaults to \code{FALSE}.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A data.frame (matrix or array) containing the posterior samples.
}
\description{
Extract posterior samples of specified parameters. The
\code{posterior_samples} method is deprecated. We recommend using the more
modern and consistent \code{\link[brms:draws-brms]{as_draws_*}} extractor
functions of the \pkg{posterior} package instead.
}
\examples{
\dontrun{
fit <- brm(rating ~ treat + period + carry + (1|subject),
           data = inhaler, family = "cumulative")

# extract posterior samples of population-level effects
samples1 <- posterior_samples(fit, pars = "^b")
head(samples1)

# extract posterior samples of group-level standard deviations
samples2 <- posterior_samples(fit, pars = "^sd_")
head(samples2)
}

}
\seealso{
\code{\link[brms:draws-brms]{as_draws}},
   \code{\link[brms:as.data.frame.brmsfit]{as.data.frame}}
}
