% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateIAE.R
\name{estimateIAE}
\alias{estimateIAE}
\alias{estimateIAE.braidrm}
\alias{estimateIAE.braidrmflip}
\alias{estimateIAE.default}
\alias{estimateFlippedIAE}
\title{BRAID Response Surface Combined Potency}
\usage{
estimateIAE(bpar, levels, limits, lowerLimits = c(0, 0))

\method{estimateIAE}{braidrm}(bpar, levels, limits, lowerLimits = c(0, 0))

\method{estimateIAE}{braidrmflip}(bpar, levels, limits, lowerLimits = c(0, 0))

\method{estimateIAE}{default}(bpar, levels, limits, lowerLimits = c(0, 0))

estimateFlippedIAE(bpar, flip, levels, limits, lowerLimits = c(0, 0))
}
\arguments{
\item{bpar}{The response surface to be evaluated.  Can be a numeric vector
(which will be treated as a standard BRAID parameter vector), a BRAID fit
object of class \code{braidrm}, or a flipped BRAID fit object of class
\code{braidrmflip}}

\item{levels}{The effect level or levels at which the index is to be
estimated}

\item{limits}{The upper concentration limits beneath which the IAE is to be
estimated.  Could be known toxicity thresholds, limits on pharmacokinetic
availability, or simply a convenient and consistent reference concentration}

\item{lowerLimits}{By default, the IAE is calculated by comparing the area
of dose space below which a given effect level is not reached with the total
achievable dose space specified by \code{limits}.  However, in some cases, it is
not desirable to allow the sub-threshold area to become infinitesimally
small. If lowerLimits is included, doses that lie below both lower limits
will always be included in the sub-threshold area, placing an effective upper
bound on possible IAE values}

\item{flip}{String specifying the direction or directions of the surface's
flip.  Must be one of "A", "B", or "both".}
}
\value{
A numeric vector, the same length as \code{levels} with the estimated
index of achievable efficacy (IAE) values for each of those levels.
}
\description{
Estimates the BRAID index of achievable efficacy (or IAE) for a given
response surface
}
\details{
The index of achievable efficacy is an aggregate measure of combined potency,
and a useful first pass for quantifying the efficacy of a given response
surface.  Formally, it is equal to the area of achievable dose pairs divided
by the area of achievable doses below which a desired effect level is not
reached (then passed through a square root to give a more dimensionless
result).  If the surface is more potent, the area of sub-threshold achievable
doses is smaller, and the IAE is larger.  If the surface is less efficacious,
the doses at which a desired effect is reach will be larger, the
sub-threshold area will increase, and the IAE will decrease.  By default, the
IAE can range from 1 to infinity, but upper bounds can be placed by setting
the values in \code{lowerLimits} to concentrations above 0.  For convenience, the
function takes BRAID parameter vectors, \code{braidrm} fit objects, and
\code{braidrmflip} flipped BRAID fit objects.  However, flipped BRAID response
surface parameters cannot be passed to the function as is, so the function
\code{estimateFlippedIAE} is also included specifically for flipped parameter
vectors.
}
\examples{

estimateIAE(c(1,1,3,3,0,0,100),c(50,90),c(5,5))

bfit <- braidrm(measure ~ concA + concB, synergisticExample, getCIs = FALSE)
estimateIAE(bfit, c(0,0.25,0.5,0.75,1), c(10,1), lowerLimits=c(0.01,0.01))
}
