% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicBraidPlot.R
\name{basicBraidPlot}
\alias{basicBraidPlot}
\title{Wrapper for Basic Braid Plot}
\usage{
basicBraidPlot(
  data,
  mapping,
  palette = "RdYlBu",
  direction = -1,
  logscale = TRUE
)
}
\arguments{
\item{data}{Dataset to use for plot. If not already a data.frame, will be
converted to one by \code{fortify()}}

\item{mapping}{List of aesthetic mappings to use for plot. \code{geom_braid}
requires at least the following aesthetics: \code{x}, \code{y}, and \code{fill}.}

\item{palette}{A Brewer color palette passed to the \code{scale_fill_distiller()}
function}

\item{direction}{The direction of the Brewer color palette, also passed to
\code{scale_fill_distiller()}}

\item{logscale}{Should x and y variables be plotted on a log scale (defaults
to \code{TRUE}). If \code{FALSE}, \code{scale_x_continuous()} and and \code{scale_y_continuous()}
will still be applied to ensure that a plot produced by this function always
has explicitly given scales.}
}
\value{
An object of class \code{ggplot} containing a \code{geom_braid()} rendering of
the respective x, y, and fill aesthetics.
}
\description{
Wrapper for Basic Braid Plot
}
\details{
Though the \code{geom_braid()} function allows for a great deal of flexibility
and keeps with the layer-based ethos of \code{ggplot}, we find that very often, it
is useful to just get a simple first pass view of a response surface, and
repeatedly typing out all the necessary layers to make the surface visible
can be extremely tiresome.  This function wraps a simple set of \code{ggplot}
functions with the \code{geom_braid()} function to produce a standard heatmap
plot that works for many of the surfaces we encounter.

Note however that this is just meant to be a convenience function.  Any more
complex or sophisticated plots should be built using \code{ggplot} layers,
including \code{geom_braid()}.
}
\examples{
surface <- synergisticExample
plot <- basicBraidPlot(surface,aes(x=concA,y=concB,fill=measure))
print(plot)
}
