% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outbox.R
\name{outBox}
\alias{outBox}
\title{Generate images with bounding boxes from coordinates in a dataframe}
\usage{
outBox(
  points_master,
  file_path_input,
  file_path_output,
  show_classifier = FALSE
)
}
\arguments{
\item{points_master}{A dataframe that captures the name of the image file,
the four coordinates of the bounding box, the width and height dimensions
of the image, the classifier, and the color for the label and box. The file
format is a follows:
file_name : (chr) name of the image file;
x_left    : (int) left side x-coordinate;
y_top     : (int) top side y-coordinate;
x_right   : (int) right side x-coordinate;
y_bottom  : (int) bottom side y-coordinate;
size_x    : (int) image width in pixels;
size_y    : (int) image height in pixels;
classifier: (chr) classifier used as label;
color     : (chr) name of color to use for box and label.}

\item{file_path_input}{The directory that contains the image files.}

\item{file_path_output}{The directory where to save annotated images.}

\item{show_classifier}{Logical to include the classifier above the bounding.
box. The default is F.}
}
\value{
A new image file with the bounding box annotation for each of the
 images processed and resized accordingly. The name of each output image
 file will be the same as the corresponding input file prefixed with "out_".
}
\description{
\code{outBox} adds colored bounding boxes and labels to images based on
predetermined coordinates, classifiers, and image dimensions captured in a
dataframe.
}
\details{
Load a dataframe that captures data points for each image to process.
The file format is the same as generated by boxer and boxer2.

Note y-coordinates should extend downward from the top, not upward from the
bottom.
}
\examples{
points_master <- data.frame(read.csv(system.file("extdata","points_example.csv",
package = "boundingbox")), stringsAsFactors = FALSE)


outBox(points_master = points_master,
file_path_input = system.file("extdata", package = "boundingbox"),
file_path_output = tempdir(), show_classifier = TRUE)

}
