% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootLR.R
\name{BayesianLR.test}
\alias{BayesianLR.test}
\title{Compute the (positive/negative) likelihood ratio with appropriate, bootstrapped confidence intervals}
\usage{
BayesianLR.test(truePos, totalDzPos, trueNeg, totalDzNeg, R = 10^4,
  nBSave = 50, verbose = FALSE, parameters = list(shrink = 5, tol =
  5e-04, nEach = 80), maxTries = 20, ci.width = 0.95,
  consistentQuantile = 0.5, ...)
}
\arguments{
\item{truePos}{The number of true positive tests.}

\item{totalDzPos}{The total number of positives ("sick") in the population.}

\item{trueNeg}{The number of true negatives in the population.}

\item{totalDzNeg}{The total number of negatives ("well") in the population.}

\item{R}{The number of replications in each round of the bootstrap (has been tested at 10,000 or greater).}

\item{nBSave}{The number of times to re-bootstrap the statistic and then average at the end to obtain confidence intervals (has been tested at 50).}

\item{verbose}{Whether to display internal operations as they happen.}

\item{parameters}{List of control parameters (shrink, tol, nEach) for sequential search.}

\item{maxTries}{Each time a run fails, BayesianLR.test will back off on the parameters and try again. maxTries specifies the number of times to try before giving up.  If you can't get it to converge, try setting this higher.}

\item{ci.width}{Changing this parameter results in different properties than have been tested and is not recommended. The width of the confidence interval used by boot.ci (not necessarily the same as the width of the CI produced by the algorithm overall)}

\item{consistentQuantile}{Changing this parameter results in different properties than have been tested and is not recommended. Defaults to 0.5, i.e. the median. Finds the lowest probability for which the random draws are likely to be consistently one, where consistently is defined by this value (i.e. at .5, a simple majority of the time is enough for consistency).}

\item{\dots}{Arguments to pass along to boot.ci for the BCa confidence intervals.}
}
\value{
An object of class lrtest.
}
\description{
Compute the (positive/negative) likelihood ratio with appropriate, bootstrapped confidence intervals. 
A standard bootstrapping approach is used for sensitivity and specificity, results are combined, and 
then 95% CIs are determined. 
For the case where sensitivity or specificity equals zero or one, an appropriate bootstrap sample is generated 
and then used in subsequent computations.
}
\details{
If the denominator is 0, calculations are inverted until the final result.
}
\note{
You'll either need a fast computer or substantial patience for certain combinations of inputs.
}
\examples{
\dontrun{
blrt <- BayesianLR.test( truePos=100, totalDzPos=100, trueNeg=60, totalDzNeg=100 )
blrt
summary(blrt)

BayesianLR.test( truePos=98, totalDzPos=100, trueNeg=60, totalDzNeg=100 )
BayesianLR.test( truePos=60, totalDzPos=100, trueNeg=100, totalDzNeg=100 )
BayesianLR.test( truePos=60, totalDzPos=100, trueNeg=99, totalDzNeg=100 )

# Note the argument names are not necessary if you specify them in the proper order:
BayesianLR.test( 60, 100, 50, 50 ) 

# You can specify R= to increase/decrease the number of bootstrap replications
BayesianLR.test( 60, 100, 50, 50, R=10000 ) 

# You can change the number of digits that are printed
print.lrtest( BayesianLR.test( 500, 500, 300, 500 ), digits = 4 )

# Or extract the results yourself
model.blrt1 <- BayesianLR.test( 500, 500, 300, 500 )
unclass( model.blrt1 )
model.blrt1$statistics
model.blrt1$posLR.ci

# If the model doesn't converge, you can alter the search parameters
BayesianLR.test( 500, 500, 300, 500, parameters=list(shrink=4,tol=.001,nEach=150), maxTries = 50 )

### Statistician-only options
# These change the way the model works. 
# It is not recommended to alter these, as this will alter the statistical properties of the test
# in ways that have not been validated.
# Change number of bootstrap replications
BayesianLR.test( 500, 500, 300, 500, R = 5*10^4 )
# Change number of times to average the confidence interval limits at the end
BayesianLR.test( 500, 500, 300, 500, nBSave = 100 )
# Change the criteria from median being consistent 0 or 1 to some other quantile
BayesianLR.test( 500, 500, 300, 500, consistentQuantile = .53 )
}
}
