% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandw1.R
\name{bandw1}
\alias{bandw1}
\title{Computing the Bandwidth of the Kernel Density Estimators.}
\usage{
bandw1(y)
}
\arguments{
\item{y}{A numeric vector representing a Markov process of a vector of points.}
}
\value{
Value of the Silverman's rule of thumb bandwidth.
}
\description{
The function computes the bandwidth of a smoothed kernel density estimators
using Silverman's rule.
}
\details{
The function compute the bandwidth
using the following formula:
\eqn{h=0.9An^{-1,5},}
where \eqn{A=\min{\left\{\hat{\sigma}; IRQ/1.34\right\}}}, where \eqn{\hat{\sigma}} is the empirical
standard deviation of the data and \eqn{IRQ} is the empirical interquartile range.
}
\examples{
n=200# the length of the process
# Generating the AR(1) process
coeff=0.75
X = arima.sim(n=n, list(ar = c(coeff)))
h = bandw1(X)
}
\references{
Tsybakov, A. B. (2018). Introduction to Nonparametric Estimation. \emph{SpringerLink.}
}
\seealso{
\code{\link{findBestEpsilon}},
\code{\link{fastNadaraya}}.
}
\keyword{"Markov}
\keyword{"Regenerative}
\keyword{"Small}
\keyword{bootstrap"}
\keyword{chains"}
\keyword{ensembles"}
