% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate.sub.R
\name{rate.sub}
\alias{rate.sub}
\title{Subsampling for i.i.d. Data with Convergence Rate Estimation}
\usage{
rate.sub(X, func, B = 999, n_b = 99, q = 0.75, PLT = TRUE, ...)
}
\arguments{
\item{X}{A numeric vector.}

\item{func}{The function to be estimated using subsampling.}

\item{B}{A positive integer; the number of subsampling replications.}

\item{n_b}{A positive integer; the number of subsampling distributions to be constructed,
with subsampling sizes ranging from \eqn{\lfloor n^{1/3}\rfloor} to \eqn{\rfloor n^{3/4}\rfloor},
where \eqn{n}
is the sample size.}

\item{q}{A numeric value in the interval \eqn{(0.5, 1)}; it is used to calculate the interquantile
range which estimates the rate of convergence.}

\item{PLT}{A logical value; By default it is \code{TRUE}, plots graphics and intermediate
regression results.}

\item{...}{Additional arguments for the \code{func} function.}
}
\value{
A list containing:
\item{alpha}{The estimated rate of convergence.}
\item{beta}{The estimated approximation rate.}
\item{obj}{An object of class \code{boodd} with the optimized subsampling distribution.}
}
\description{
Performs subsampling for an i.i.d. data with an estimation of the convergence rate
of a given statistic.
The function constructs subsampling distributions of specified sizes, estimates the convergence rate
and asymptotic bias, and provides optional diagnostic plots.
}
\details{
The function \code{rate.block} performs subsampling, specifically
suited for i.i.d. data, estimates the convergence rate \eqn{n^{-\alpha}} and the approximation
rate \eqn{n^{-\beta}} between the true distribution and the asymptotic one.
}
\examples{
#' set.seed(12345)
n = 500 # sample size
x = rnorm(n)
# Subsampling with estimated rate
reb=rate.sub(x,mean,PLT=TRUE, B=99)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..

Bertail, P.,  Politis, D., Romano, J. (1999).
On Subsampling Estimators with Unknown Rate of Convergence.

Politis, D. N., Romano, J. P., & Wolf, M. (1999). \emph{Subsampling}. Springer N.Y..
}
\seealso{
\code{\link{rate.block.sub}}, \code{\link{best.block.sub.size}},
\code{\link{best.sub.size.iid}}, \code{\link{block.sub}}, \code{\link{boots}}.
}
\keyword{"Convergence}
\keyword{Subsampling}
\keyword{estimation"}
\keyword{rate}
