% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_process.R
\name{genMM1}
\alias{genMM1}
\title{Generate an M/M/1 Queue Process}
\usage{
genMM1(n, lambda, mu, out = NULL)
}
\arguments{
\item{n}{An integer value; the length of the process to simulate.}

\item{lambda}{A positive numeric value; rate parameter for the Poisson
arrival process.}

\item{mu}{A positive numeric value; rate parameter for the exponential service times.}

\item{out}{A positive numeric value; the value of an outlier appearing
at time \eqn{floor(n/2)+1}.
Default is \code{NULL}, this means that the process is generated without
outlier.}
}
\value{
A numeric vector of length \code{n+1}, representing the waiting time of
customer \eqn{i} arriving at time \eqn{T_i}.
}
\description{
Simulates an M/M/1 queue process.
The M/M/1 queue is a single-server queue with Poisson arrivals and
exponential service times. Allows to introduce an artificial outlier.
}
\details{
The M/M/1 waiting time is defined as follows
\deqn{X_{t+1} = \max(0, (X_t + U_t - V_t))},
where \eqn{U_t} and \eqn{V_t} are exponentially distributed random variables with
parameters \code{lambda} and \code{mu}, respectively.
}
\examples{
queue = genMM1(100,1,2) 
plot(queue, type="l")

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Asmussen, S. (1987). \emph{Applied Probability and Queues}. Springer N.Y.
}
\seealso{
\code{\link{genETARCH}}, \code{\link{zi_inar_process}}.
}
\keyword{"Queueing}
\keyword{system"}
