% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldbootP.R
\name{fieldbootP}
\alias{fieldbootP}
\title{Bootstrap Sample from the Random Field}
\usage{
fieldbootP(
  arr,
  length.block,
  method = c("movingblock", "nonoverlapping", "circular")
)
}
\arguments{
\item{arr}{A multidimensional real-valued array; it represents a random field on a grid of dimension
equals to dimension of the \code{arr}.}

\item{length.block}{An integer or vector of integers; it specified the block lengths for blocks.
If a scalar is provided, the same block length is used for all dimensions.}

\item{method}{The method for array reconstruction:
\itemize{
\item \code{"movingblock"} - Moving Block Bootstrap,
\item \code{"nonoverlapping"} - Nonoverlapping Block Bootstrap,
\item \code{"circular"} - Circular Block Bootstrap (obtained by wrapping the field on the torus).
Default is \code{"movingblock"}.
}}
}
\value{
Returns a bootstrap sample of given \code{arr}.
}
\description{
Function returns a bootstrap sample of the random field on a lattice, using
various block bootstrap methods such as moving block, circular block, or
nonoverlapping block bootstrap.
}
\details{
In the case of random fields, the blocks \eqn{B_{i}}'s are random matrices of size
\code{length.block}. From the set of all blocks
\eqn{\mathcal{B}=\{B_{1},B_{2},\dots,B_{q}\},} we select
randomly with replacement blocks \eqn{B_{1}^{\ast},\dots,B_{l}^{\ast}} and bind them together. The
probability of choosing any block is \eqn{1/q}.
}
\examples{
\donttest{
library(geoR)
N=10
n=N^2
sim <- grf(n, grid="reg", cov.pars=c(1, .25), nsim=1)
image(sim) 
arr=array(sim$data,dim=c(N,N))
mb=fieldbootP(arr,length.block=c(2,2),method="movingblock")
simb=sim
simb$data=as.vector(mb)
image(simb)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P.  Politis, D. N. Rhomari, N. (2000). Subsampling continuous
parameter random fields and a Bernstein inequality,  \emph{Statistics},
\bold{33}, 367-392.

Nordman, D.J.  Lahiri, S.N.(2004). On optimal spatial subsample size for
variance estimation, \emph{The Annals of Statistics}, \bold{32}, 1981-2027.

Politis,  D.N. Romano, J.P. (1993). Nonparametric Resampling for Homogeneous
Strong Mixing Random Fields, \emph{J. Multivar. Anal.}, \bold{47}, 301-328.
}
\seealso{
\code{\link{blockboot}},
\code{\link{jackVarField}},
\code{\link{field.sub}}, \code{\link{fieldboot}}.
}
\keyword{"Bootstrap"}
\keyword{"Random}
\keyword{fields"}
