% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boodd-class.R
\docType{class}
\name{class.boodd}
\alias{class.boodd}
\title{Objects of Class \code{boodd}}
\value{
An object of class \code{boodd}, which is a list with at least:
\itemize{
\item \code{$s} – a vector or matrix of bootstrap statistics.
\item \code{$Tn} – the value of the statistic on the original data.
}
}
\description{
The bootstrap functions in this package return an object of class \code{boodd},
which contains the values of bootstrapped statistics and the statistic computed on the original data.
Generic functions such as \code{plot}, \code{confint}, and \code{summary} can be applied to these objects.
}
\details{
A \code{boodd} object has the following attributes:
\itemize{
\item \code{"class"} – always "boodd".
\item \code{"kind"} – the type of bootstrap applied, such as "iid", "block", "movingblock", "circular",
"aided", "semi", "sub-block", "regenerative", "frequency", "sieve", "bootglm", "randomfield", "TFT",
"parametric", "i.i.d. subsampling with estimated rate", "subsampling with rates estimation".
\item \code{"func"} – the function that was bootstrapped.
}
}
\examples{
set.seed(123)
data <- rnorm(100)
boot_result <- boots(data, mean, 1000)
summary(boot_result)
plot(boot_result)

}
\references{
Bertail, P., & Dudek, A. (2025). \emph{Bootstrap for Dependent Data, with an R package}
(by Bernard Desgraupes and Karolina Marek) – submitted. \cr
Efron, B., & Tibshirani, R. (1993). \emph{An Introduction to the Bootstrap}. Chapman and Hall.
}
\seealso{
\code{\link{boots}}, \code{\link{boot_dist}}, \code{\link{tboot_dist}},
\code{\link{plot.boodd}}, \code{\link{confint.boodd}}, \code{\link{summary.boodd}},
\code{\link{bootsemi}}, \code{\link{blockboot}}, \code{\link{regenboot}}, \code{\link{freqboot}},
\code{\link{aidedboot}}, \code{\link{sieveboot}}, \code{\link{bootglm}}, \code{\link{fieldboot}},
\code{\link{tft_boot}}, \code{\link{para.boot}}, \code{\link{mark_boot}}, \code{\link{rate.sub}},
\code{\link{rate.block.sub}}
}
\keyword{"Bootstrap"}
\keyword{"Dependent}
\keyword{"Time}
\keyword{Semiparametric}
\keyword{data"}
\keyword{series"}
