% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.sub.size.iid.R
\name{best.sub.size.iid}
\alias{best.sub.size.iid}
\title{Optimal Block Subsampling or MOON Bootstrap Sizes for I.I.D. Data}
\usage{
best.sub.size.iid(X, func, B = 999, PLT = TRUE, qq = 0.75, rep = FALSE, ...)
}
\arguments{
\item{X}{A numeric vector or data representing i.i.d. observations.}

\item{func}{A function pplied to the blocks.}

\item{B}{An integer; the number of resampling replications.
Default is \eqn{999}.}

\item{PLT}{Logical. If \code{TRUE} (default), plots the Kolmogorov distances
versus subsampling sizes and intermediate regression results.}

\item{qq}{A numeric value in the interval \eqn{(0, 1)}. Determines the scaling
factor for subsampling sizes. Higher values result in more subsampling
distributions being computed. Default is \eqn{0.75}.}

\item{rep}{Logical. If \code{TRUE}, performs moon bootstrap (subsampling with replacement).
If \code{FALSE} (default), performs subsampling without replacement.}

\item{...}{Optional additional arguments passed to the \code{func} function.}
}
\value{
Returns the optimal block size for subsampling or moon bootstrap.
}
\description{
This function determines the optimal block size for subsampling
or moon bootstrap sizes
using a distance-based method, specifically applying undersampling techniques
for independent and identically distributed (i.i.d.) data. It computes
Kolmogorov distances between consecutive subsampling (or moon bootstrap) distributions to
select the most suitable block size.
}
\details{
This function implements a procedure based on the method proposed by Götze and Račkauskas (2001) and
Bickel and Sakov (2008) for determining optimal subsampling sizes in i.i.d. case. It computes
a range of subsampling distributions or moon bootstrap distribution for sizes
proportional to powers of \code{qq}.
The function then evaluates the Kolmogorov distance between consecutive distributions.
The optimal block size is the value which minimises this distance.

Sometimes looking at the plot is more informative, especially when the distance
does not vary very much. In this case, the largest value in a stable zone will
be a better choice than the minimiser of the distance.
}
\examples{
 set.seed(12345)
 n = 1000 # sample size
 ts = rnorm(n)
 bopt=best.sub.size.iid(ts,max)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bickel, P., and Sakov, A. (2008). On the choice of m in the m out of n bootstrap and
confidence bounds for extrema. \emph{Statistica Sinica}, \bold{18} 967–985.

Götze, F. and Račkauskas, A. (2001).
Adaptive choice of bootstrap sample sizes. In \emph{State of the art in probability and statistics.}
Institute of Mathematical Statistics,
pp. 286-310.
}
\seealso{
{\code{\link{block.sub}},
\code{\link{rate.sub}},
\code{\link{rate.block.sub}},
\code{\link{best.block.sub.size}}}.
}
\keyword{bootstrap}
