% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/d08_computingApproxMacDurationUsingApprModifDuration.R
\name{approxMacDurationUsingApprModifDuration}
\alias{approxMacDurationUsingApprModifDuration}
\title{Calculates the Approximated Macaulay duration using the Approximate Modified Duration and Yield-To-Maturity.}
\usage{
approxMacDurationUsingApprModifDuration(approxModifDuration, periodicYtm)
}
\arguments{
\item{approxModifDuration}{A number.}

\item{periodicYtm}{A number.}
}
\value{
Input values to two arguments  \code{approxModifDuration}  and \code{periodicYtm}.
}
\description{
Calculates the Approximated Macaulay duration using the Approximate Modified Duration and Yield-To-Maturity.
}
\details{
According to information provided by Adams and Smith (2019), the method \code{approxMacDurationUsingApprModifDuration()} is developed to calculate the Approximated Macaulay duration using the Approximate Modified Duration and Yield-To-Maturity.
}
\examples{
approxMacDurationUsingApprModifDuration(approxModifDuration=13.466,periodicYtm=0.0257)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Understanding Fixed‑Income Risk and Return. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 237-299). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
