% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate_standardise_measures.R
\name{boilerplate_standardise_measures}
\alias{boilerplate_standardise_measures}
\title{Standardise Measure Entries in Database}
\usage{
boilerplate_standardise_measures(
  db,
  measure_names = NULL,
  extract_scale = TRUE,
  identify_reversed = TRUE,
  clean_descriptions = TRUE,
  ensure_structure = TRUE,
  standardise_references = TRUE,
  json_compatible = FALSE,
  verbose = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{db}{List. Either a single measure or a measures database to standardise.}

\item{measure_names}{Character vector. Specific measures to standardise. If NULL, processes all.}

\item{extract_scale}{Logical. Extract scale information from descriptions. Default is TRUE.}

\item{identify_reversed}{Logical. Identify reversed items. Default is TRUE.}

\item{clean_descriptions}{Logical. Clean up description text. Default is TRUE.}

\item{ensure_structure}{Logical. Ensure all measures have standard fields. Default is TRUE.}

\item{standardise_references}{Logical. Standardise reference format. Default is TRUE.}

\item{json_compatible}{Logical. Ensure JSON-compatible structure by converting vectors to lists
and removing NULL values. Default is FALSE.}

\item{verbose}{Logical. Show detailed progress information. Default is FALSE.}

\item{quiet}{Logical. Suppress all messages. Default is FALSE.}
}
\value{
List. The standardised measure(s) or database.
}
\description{
This function standardises measure entries by extracting scale information,
identifying reversed items, cleaning descriptions, and ensuring consistent structure.
}
\examples{
# Create a temporary directory and initialise database
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_standardise_example", "data")

# Initialise database
boilerplate_init(
  categories = "measures",
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = FALSE,
  confirm = FALSE,
  quiet = TRUE
)

# Import database
unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)

# Standardise all measures in database
unified_db$measures <- boilerplate_standardise_measures(
  unified_db$measures,
  quiet = TRUE
)

# Standardise with JSON compatibility
unified_db$measures <- boilerplate_standardise_measures(
  unified_db$measures,
  json_compatible = TRUE,
  quiet = TRUE
)

# Check that standardisation worked
names(unified_db$measures$anxiety)

# Standardise specific measures only
unified_db$measures <- boilerplate_standardise_measures(
  unified_db$measures,
  measure_names = c("anxiety", "depression"),
  quiet = TRUE
)

# Clean up
unlink(file.path(temp_dir, "boilerplate_standardise_example"), recursive = TRUE)

}
