% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-text.R
\name{boilerplate_generate_text}
\alias{boilerplate_generate_text}
\title{Generate Text from boilerplate}
\usage{
boilerplate_generate_text(
  category = c("measures", "methods", "results", "discussion", "appendix", "template"),
  sections,
  global_vars = list(),
  section_vars = list(),
  text_overrides = list(),
  db = NULL,
  data_path = NULL,
  warn_missing = TRUE,
  add_headings = FALSE,
  heading_level = "###",
  custom_headings = list(),
  quiet = FALSE,
  create_dirs = FALSE,
  confirm = TRUE,
  copy_bibliography = FALSE,
  bibliography_path = "."
)
}
\arguments{
\item{category}{Character. Category of text to generate.}

\item{sections}{Character vector. The sections to include (can use dot notation for nesting).}

\item{global_vars}{List. Variables available to all sections.}

\item{section_vars}{List. Section-specific variables.}

\item{text_overrides}{List. Direct text overrides for specific sections.}

\item{db}{List. Optional database to use. Can be either a category-specific database or a unified database.
If a unified database is provided, the appropriate category will be extracted.}

\item{data_path}{Character. Path to the directory where database files are stored.
If NULL (default), uses tools::R_user_dir("boilerplate", "data").}

\item{warn_missing}{Logical. Whether to warn about missing template variables.}

\item{add_headings}{Logical. Whether to add markdown headings to sections. Default is FALSE.}

\item{heading_level}{Character. The heading level to use (e.g., "###"). Default is "###".}

\item{custom_headings}{List. Custom headings for specific sections. Names should match section names.}

\item{quiet}{Logical. If TRUE, suppresses all CLI alerts. Default is FALSE.}

\item{create_dirs}{Logical. If TRUE, creates directories that don't exist. Default is FALSE.}

\item{confirm}{Logical. If TRUE, asks for confirmation before creating directories. Default is TRUE.}

\item{copy_bibliography}{Logical. If TRUE, copies bibliography file to the project. Default is FALSE.}

\item{bibliography_path}{Character. Directory to copy bibliography file to. Default is "." (current directory).}
}
\value{
Character. The combined text with optional headings.
}
\description{
This function generates text by retrieving and combining text from
a boilerplate database. It allows for template variable substitution and
customisation through overrides. Supports arbitrarily nested section paths
using dot notation.
}
\examples{
# Create a temporary directory and initialise databases
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_text_example", "data")

# Initialise with default content
boilerplate_init(
  categories = c("methods", "results"),
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = FALSE,
  confirm = FALSE,
  quiet = TRUE
)

# Import the databases
unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)

# Basic usage with methods sections
methods_text <- boilerplate_generate_text(
  category = "methods",
  sections = c("sample"),
  global_vars = list(
    exposure_var = "political_conservative",
    population = "university students",
    timeframe = "2023-2024"
  ),
  db = unified_db,
  quiet = TRUE
)

# Check the output
cat(substr(methods_text, 1, 100), "...\n")

# Using with headings
methods_text <- boilerplate_generate_text(
  category = "methods",
  sections = c("sample"),
  global_vars = list(
    exposure_var = "treatment",
    timeframe = "2023-2024"
  ),
  db = unified_db,
  add_headings = TRUE,
  heading_level = "##",
  quiet = TRUE
)

# Clean up
unlink(file.path(temp_dir, "boilerplate_text_example"), recursive = TRUE)

}
