% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_values.R
\name{reference_values}
\alias{reference_values}
\title{Get reference values for a given combination of model and percentile/z-score}
\usage{
reference_values(
  metric,
  sex,
  level,
  age,
  percentile = NULL,
  z_score = NULL,
  verbose = FALSE,
  digits = 0
)
}
\arguments{
\item{metric}{character (vector), body composition metric}

\item{sex}{character (vector), ""Female" or "Male"}

\item{level}{character (vector), used vertebral level}

\item{age}{integer (vector), age}

\item{percentile}{numeric (vector), percentile to return value for. If both percentile and z_score are given, only percentile is evaluated}

\item{z_score}{numeric (vector), z score to return value for. If both percentile and z_score are given, only percentile is evaluated}

\item{verbose}{logical, should messages be displayed}

\item{digits}{integer, digits to round return value to}
}
\value{
numeric, corresponding percentile
}
\description{
For a given constellation of metric, sex, vertebral level, and age returns the corresponding measurements to a given percentile/z-score
}
\examples{
\dontshow{if (requireNamespace("adiposerefdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
reference_values(metric=c("CSFA", "CSFA"), sex=c("Female","Male"),
                 level=c("T5","L3"), age=c(42,68), percentile=c(50,50))

\dontshow{\}) # examplesIf}
}
\seealso{
[bodycomp_reference()]
}
\author{
J. Peter Marquardt
}
