% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.outliers.R
\name{preprocess.outliers}
\alias{preprocess.outliers}
\title{Extract information of outliers}
\usage{
preprocess.outliers(data.to.work, variable.content, variable.name)
}
\arguments{
\item{data.to.work}{is a data frame containing the variables.}

\item{variable.content}{is a variable with all content of variable in the data set.}

\item{variable.name}{is the name of variable to be verified.}
}
\value{
a list with number of outliers and the variable content
}
\description{
This function receives a data set, the variable content and name, analyzes their content and extract outliers information, showing a boxplot and a histogram.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("to your working directory")
# Load packages
library(bnpa)
# Load data sets from package
data(dataQuantC)
# Set parameters to function
variable.content <- dataQuantC$A
variable.name <- "A"
# Preprocess information
preprocess.information <- preprocess.outliers(dataQuantC, variable.content, variable.name)
num.outliers <- preprocess.information[[1]]
variable.content <- preprocess.information[[2]]
mean.of.outliers <- preprocess.information[[3]]
}
\references{
GUJARATI, Damodar N. Basic econometrics. Tata McGraw-Hill Education, 2009.
}
\author{
Elias Carvalho
}
