% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure.R
\name{measure_cont}
\alias{measure_cont}
\title{Measure Performance for Continuous Response Models}
\usage{
measure_cont(obs, pred)
}
\arguments{
\item{obs}{A numeric vector of observed (true) values.}

\item{pred}{A numeric vector of predicted values.}
}
\value{
A list containing:
\describe{
\item{\code{rmse}}{Root Mean Squared Error.}
\item{\code{mae}}{Mean Absolute Error.}
}
}
\description{
Evaluates the performance of a continuous response model using RMSE and MAE.
}
\examples{
obs <- c(3.2, 4.1, 5.6)
pred <- c(3.0, 4.3, 5.5)
measure_cont(obs, pred)
# Returns: list(rmse = 0.1732051, mae = 0.1666667)

}
