% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{mixture2p_dist}
\alias{mixture2p_dist}
\alias{dmixture2p}
\alias{pmixture2p}
\alias{qmixture2p}
\alias{rmixture2p}
\title{Distribution functions for the two-parameter mixture model (mixture2p)}
\usage{
dmixture2p(x, mu = 0, kappa = 5, p_mem = 0.6, log = FALSE)

pmixture2p(q, mu = 0, kappa = 7, p_mem = 0.8)

qmixture2p(p, mu = 0, kappa = 5, p_mem = 0.6)

rmixture2p(n, mu = 0, kappa = 5, p_mem = 0.6)
}
\arguments{
\item{x}{Vector of observed responses}

\item{mu}{Vector of locations}

\item{kappa}{Vector of precision values}

\item{p_mem}{Vector of probabilities for memory recall}

\item{log}{Logical; if \code{TRUE}, values are returned on the log scale.}

\item{q}{Vector of quantiles}

\item{p}{Vector of probability}

\item{n}{Number of observations to generate data for}
}
\value{
\code{dmixture2p} gives the density of the two-parameter mixture model,
\code{pmixture2p} gives the cumulative distribution function of the
two-parameter mixture model, \code{qmixture2p} gives the quantile function of
the two-parameter mixture model, and \code{rmixture2p} gives the random
generation function for the two-parameter mixture model.
}
\description{
Density, distribution, and random generation functions for the
two-parameter mixture model with the location of \code{mu}, precision of memory
representations \code{kappa} and probability of recalling items from memory
\code{p_mem}.
}
\examples{
# generate random samples from the mixture2p model and overlay the density
r <- rmixture2p(10000, mu = 0, kappa = 4, p_mem = 0.8)
x <- seq(-pi, pi, length.out = 10000)
d <- dmixture2p(x, mu = 0, kappa = 4, p_mem = 0.8)
hist(r, breaks = 60, freq = FALSE)
lines(x, d, type = "l", col = "red")

}
\references{
Zhang, W., & Luck, S. J. (2008). Discrete fixed-resolution
representations in visual working memory. Nature, 453.
}
\keyword{distribution}
